/*
 * Decompiled with CFR 0.152.
 */
package lukfor.progress;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import lukfor.progress.Components;
import lukfor.progress.TaskService;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.TaskFailureStrategy;
import lukfor.progress.tasks.monitors.ITaskMonitor;

public class Showcase {
    public static void main(String[] args) {
        TaskService.setAnsiColors(true);
        TaskService.setThreads(3);
        TaskService.setFailureStrategy(TaskFailureStrategy.CANCEL_TASKS);
        ITaskRunnable task1 = Showcase.createTask("task1", 500, 100);
        ITaskRunnable task2 = Showcase.createTask("task2", 600, 200);
        ITaskRunnable task3 = Showcase.createTask("task3", 800, -1);
        TaskService.monitor(Components.SPINNER, Components.TASK_NAME, Components.DEFAULT).run(task1, task2, task3);
    }

    public static ITaskRunnable createTask(final String name, final int max, final int stop) {
        return new ITaskRunnable(){

            @Override
            public void run(ITaskMonitor monitor) throws IOException {
                monitor.begin(name, max);
                int i = 0;
                while (i < max) {
                    if (monitor.isCanceled()) break;
                    monitor.worked(1L);
                    try {
                        if (i == stop) {
                            throw new IOException("Input file not found.");
                        }
                        TimeUnit.MILLISECONDS.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
        };
    }
}

