/*
 * Decompiled with CFR 0.152.
 */
package lukfor.progress.renderer.bars;

import lukfor.progress.renderer.IProgressIndicator;
import lukfor.progress.tasks.monitors.TaskMonitor;
import lukfor.progress.util.AnsiColors;

public class AbstractProgressBar
implements IProgressIndicator {
    public static float SPEED = 0.01f;
    private String progress = AnsiColors.cyan("#");
    private String tick = AnsiColors.cyan(">");
    private String empty = AnsiColors.blue("-");
    private String borderLeft = "[";
    private String borderRight = "]";
    private int width = 40;

    public String getProgress() {
        return this.progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public String getTick() {
        return this.tick;
    }

    public void setTick(String tick) {
        this.tick = tick;
    }

    public String getEmpty() {
        return this.empty;
    }

    public void setEmpty(String empty) {
        this.empty = empty;
    }

    public String getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(String borderLeft) {
        this.borderLeft = borderLeft;
    }

    public String getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(String borderRight) {
        this.borderRight = borderRight;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void render(TaskMonitor monitor, StringBuilder buffer) {
        buffer.append(this.getBorderLeft());
        int width = this.getWidth() - this.getBorderLeft().length() - this.getBorderRight().length();
        String tick = this.getTick();
        if (monitor.getTotal() == -1L || monitor.getTotal() == 0L) {
            int frame = (int)((float)monitor.getExecutionTime() * SPEED);
            int position = frame % width;
            if (position > 0) {
                buffer.append((CharSequence)this.repeat(this.getEmpty(), position - 1));
            }
            if (tick != null) {
                buffer.append(tick);
            } else {
                buffer.append(this.getProgress());
            }
            if (width > position) {
                buffer.append((CharSequence)this.repeat(this.getEmpty(), width - position - (position == 0 ? 1 : 0)));
            }
        } else {
            int progress = (int)((long)width * monitor.getWorked() / monitor.getTotal());
            buffer.append((CharSequence)this.repeat(this.getProgress(), progress));
            if (monitor.getWorked() == monitor.getTotal()) {
                tick = null;
            }
            if (tick != null) {
                buffer.append(tick);
            }
            buffer.append((CharSequence)this.repeat(this.getEmpty(), width - progress - (tick != null ? 1 : 0)));
        }
        buffer.append(this.getBorderRight());
    }

    protected StringBuilder repeat(String string, int count) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < count) {
            result.append(string);
            ++i;
        }
        return result;
    }
}

