/*
 * Decompiled with CFR 0.152.
 */
package lukfor.progress.renderer.spinners;

import lukfor.progress.renderer.IProgressIndicator;
import lukfor.progress.tasks.monitors.TaskMonitor;
import lukfor.progress.util.AnsiColors;

public class DefaultSpinner
implements IProgressIndicator {
    public static final float FRAME_RATE = 0.01f;
    public static final String SEQUENCE = "\u2801\u2801\u2809\u2819\u281a\u2812\u2802\u2802\u2812\u2832\u2834\u2824\u2804\u2804\u2824\u2820\u2820\u2824\u2826\u2816\u2812\u2810\u2810\u2812\u2813\u280b\u2809\u2808\u2808 ";

    @Override
    public void render(TaskMonitor monitor, StringBuilder buffer) {
        if (monitor.isDone()) {
            if (monitor.isSuccess()) {
                buffer.append(AnsiColors.green(" \u2714\ufe0f "));
            } else if (monitor.isCanceled()) {
                buffer.append(AnsiColors.red(" \u274c "));
            } else {
                buffer.append(AnsiColors.red(" \u26a0\ufe0f "));
            }
        } else {
            int frame = this.getFrame(monitor, 0.01f) % SEQUENCE.length();
            buffer.append(AnsiColors.cyan(" " + SEQUENCE.charAt(frame) + " "));
        }
    }

    public int getFrame(TaskMonitor monitor, float frameRate) {
        return (int)((float)monitor.getExecutionTime() * frameRate);
    }
}

