/*
 * Decompiled with CFR 0.152.
 */
package lukfor.progress.tasks;

import java.util.Iterator;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.monitors.ITaskMonitor;

public abstract class AbstractIteratorTask<e>
implements ITaskRunnable {
    private Iterator<e> iterator;

    public AbstractIteratorTask(Iterator<e> iterator) {
        this.iterator = iterator;
    }

    @Override
    public void run(ITaskMonitor monitor) {
        assert (this.iterator != null) : "iterator should not be null";
        monitor.begin("Process collection...", this.getSize());
        this.process(new MonitorIterator<e>(monitor, this.iterator));
        monitor.done();
    }

    public abstract void process(Iterator<e> var1);

    public abstract long getSize();

    public static class MonitorIterator<f>
    implements Iterator<f> {
        private Iterator<f> iterator;
        private ITaskMonitor monitor;

        public MonitorIterator(ITaskMonitor monitor, Iterator<f> iterator) {
            this.monitor = monitor;
            this.iterator = iterator;
        }

        @Override
        public f next() {
            this.monitor.worked(1L);
            return this.iterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

