/*
 * Decompiled with CFR 0.152.
 */
package lukfor.progress.tasks.monitors;

import java.util.concurrent.CancellationException;
import lukfor.progress.renderer.IProgressRenderer;
import lukfor.progress.tasks.monitors.ITaskMonitor;

public class TaskMonitor
implements ITaskMonitor {
    private long worked = 0L;
    private long total;
    private String task;
    private long startTime = -1L;
    private long endTime = -1L;
    private IProgressRenderer renderer;
    private boolean running = false;
    private boolean done = false;
    private boolean success = false;
    private boolean canceled = false;
    private Throwable throwable;

    @Override
    public void begin(String name, long totalWork) {
        this.task = name;
        this.total = totalWork;
        this.running = true;
        if (this.renderer != null) {
            this.renderer.begin(this);
        }
    }

    @Override
    public void begin(String name) {
        this.begin(name, -1L);
    }

    @Override
    public void done() {
        if (this.done) {
            return;
        }
        this.endTime = System.currentTimeMillis();
        this.worked = this.total;
        this.running = false;
        this.done = true;
        this.success = true;
        if (this.renderer != null) {
            this.renderer.finish(this);
        }
    }

    @Override
    public void failed(Throwable throwable) {
        if (this.done && !this.success) {
            return;
        }
        this.endTime = System.currentTimeMillis();
        this.running = false;
        this.done = true;
        this.success = false;
        this.throwable = throwable;
        if (this.renderer != null) {
            this.renderer.finish(this);
        }
    }

    @Override
    public void update(String name) {
        this.task = name;
    }

    @Override
    public void worked(long work) {
        this.worked += work;
    }

    public long getWorked() {
        return this.worked;
    }

    public long getTotal() {
        return this.total;
    }

    public long getExecutionTime() {
        if (this.isDone()) {
            return this.endTime - this.startTime;
        }
        if (this.isRunning()) {
            return System.currentTimeMillis() - this.startTime;
        }
        return -1L;
    }

    public void setRenderer(IProgressRenderer renderer) {
        this.renderer = renderer;
    }

    public String getTask() {
        return this.task;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isDone() {
        return this.done;
    }

    public void start() {
        this.running = true;
        this.done = false;
        this.startTime = System.currentTimeMillis();
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
        this.done = true;
        this.setThrowable(new CancellationException());
        if (this.isRunning()) {
            this.endTime = this.startTime;
            if (this.renderer != null) {
                this.renderer.finish(this);
            }
        }
    }
}

