/*
 * Decompiled with CFR 0.152.
 */
package lukfor.reports;

import io.marioslab.basis.template.Template;
import io.marioslab.basis.template.TemplateContext;
import io.marioslab.basis.template.TemplateLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import lukfor.reports.HtmlReportAssets;
import lukfor.reports.functions.ArrayHelperFunction;
import lukfor.reports.functions.ImageFunction;
import lukfor.reports.functions.ImageUrlFunction;
import lukfor.reports.functions.IncludeScriptFunction;
import lukfor.reports.functions.IncludeStyleFunction;
import lukfor.reports.functions.JsonFunction;
import lukfor.reports.functions.text.DecimalFunction;
import lukfor.reports.functions.text.PercentageFunction;
import lukfor.reports.util.FileUtil;

public class HtmlReport {
    private boolean selfContained = true;
    private boolean useClasspath = true;
    private String inputDirectory;
    private Date createdOn;
    public String mainFilename = "index.html";
    private TemplateLoader loader;
    private TemplateContext context;
    private HtmlReportAssets assets;

    public HtmlReport(String inputDirectory) {
        this.inputDirectory = inputDirectory;
        this.loader = new TemplateLoader.ClasspathTemplateLoader();
        this.context = new TemplateContext();
    }

    public void set(String name, Object value) {
        this.context.set(name, value);
    }

    public void setMainFilename(String mainFilename) {
        this.mainFilename = mainFilename;
    }

    public void setSelfContained(boolean selfContained) {
        this.selfContained = selfContained;
    }

    public boolean isSelfContained() {
        return this.selfContained;
    }

    public void setUseClasspath(boolean useClasspath) {
        this.useClasspath = useClasspath;
    }

    public boolean isUseClasspath() {
        return this.useClasspath;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public Template loadTemplate(String path) {
        String filename = this.inputDirectory + "/" + path;
        return this.loader.load(filename);
    }

    public String renderTemplate(String path) {
        Template template = this.loadTemplate(path);
        return template.render(this.context);
    }

    public byte[] getBytes(String path) throws Exception {
        String filename = this.inputDirectory + "/" + path;
        if (this.useClasspath) {
            return FileUtil.readBytesFromClasspath(filename);
        }
        return FileUtil.readBytesFromFile(filename);
    }

    public String copyToAssets(String path) throws Exception {
        byte[] bytes = this.getBytes(path);
        String filename = this.assets.addToAssets(path, bytes);
        return filename;
    }

    public String renderTemplateAndCopyToAssets(String path) throws Exception {
        String content = this.renderTemplate(path);
        String filename = this.assets.addToAssets(path, content.getBytes());
        return filename;
    }

    public void generate(File outputFile) throws IOException {
        System.out.println("Process file " + this.inputDirectory + "/" + this.mainFilename + "...");
        this.createdOn = new Date();
        this.context.set("report", (Object)this);
        this.context.set("include_style", (Object)new IncludeStyleFunction(this));
        this.context.set("import_style", (Object)new IncludeStyleFunction(this));
        this.context.set("include_script", (Object)new IncludeScriptFunction(this));
        this.context.set("import_script", (Object)new IncludeScriptFunction(this));
        this.context.set("json", (Object)new JsonFunction());
        this.context.set("array", (Object)new ArrayHelperFunction());
        this.context.set("image", (Object)new ImageFunction(this));
        this.context.set("image_url", (Object)new ImageUrlFunction(this));
        this.context.set("percentage", (Object)new PercentageFunction());
        this.context.set("decimal", (Object)new DecimalFunction());
        this.assets = new HtmlReportAssets(outputFile);
        Template template = this.loadTemplate(this.mainFilename);
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        template.render(this.context, (OutputStream)outputStream);
        outputStream.close();
        System.out.println("HTML Report written to " + outputFile.getAbsolutePath() + ".");
    }
}

