/*
 * Decompiled with CFR 0.152.
 */
package lukfor.reports;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Function;
import lukfor.reports.HtmlReport;
import lukfor.reports.functions.IncludeScriptFunction;
import lukfor.reports.functions.IncludeStyleFunction;
import lukfor.reports.widgets.IWidget;
import lukfor.reports.widgets.WidgetFactory;
import lukfor.reports.widgets.WidgetInstance;
import lukfor.reports.widgets.WidgetRenderFunction;

public class HtmlWidgetsReport
extends HtmlReport {
    protected Map<String, IWidget> importedWidgets = new HashMap<String, IWidget>();
    private List<WidgetInstance> instances = new Vector<WidgetInstance>();

    public HtmlWidgetsReport(String inputDirectory) {
        super(inputDirectory);
        this.set("import_widget", new Function<String, String>(){

            @Override
            public String apply(String id) {
                IWidget widget = HtmlWidgetsReport.this.importWidget(id);
                HtmlWidgetsReport.this.set(widget.getId(), new WidgetRenderFunction(HtmlWidgetsReport.this, widget));
                return HtmlWidgetsReport.this.getHead(widget);
            }
        });
        this.set("activate_widgets", new Function<String, String>(){

            @Override
            public String apply(String arg0) {
                return HtmlWidgetsReport.this.getScript();
            }
        });
    }

    public void addInstance(WidgetInstance instance) {
        this.instances.add(instance);
    }

    protected IWidget importWidget(String id) {
        IWidget widget = this.importedWidgets.get(id);
        if (widget == null) {
            widget = WidgetFactory.createWidget(id, this);
            this.importedWidgets.put(id, widget);
        }
        return widget;
    }

    protected String getHead(IWidget widget) {
        IncludeStyleFunction styleFunction = new IncludeStyleFunction(this);
        String html = "<!-- Widget: " + widget.getId() + " -->\n";
        for (String style : widget.getStyles()) {
            html = html + styleFunction.apply(style) + "\n";
        }
        return html;
    }

    protected String getHead() {
        String head = "";
        for (IWidget widget : this.importedWidgets.values()) {
            head = head + this.getHead(widget);
        }
        return head;
    }

    protected String getScript() {
        IncludeScriptFunction scriptFunction = new IncludeScriptFunction(this);
        String html = "";
        for (IWidget widget : this.importedWidgets.values()) {
            html = html + "\n";
            html = html + "<!-- Widget: " + widget.getId() + " -->\n";
            for (String script : widget.getScripts()) {
                html = html + scriptFunction.apply(script) + "\n";
            }
        }
        html = html + "\n";
        html = html + "<!-- Init Widgets -->\n";
        html = html + "<script>\n";
        html = html + "$(document).ready( function () {\n";
        for (WidgetInstance instance : this.instances) {
            html = html + "\n";
            html = html + instance.getScript();
        }
        html = html + "});\n";
        html = html + "</script>";
        return html;
    }
}

