/*
 * Decompiled with CFR 0.152.
 */
package lukfor.reports;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import lukfor.reports.HtmlWidgetsReport;
import lukfor.reports.widgets.IWidget;
import lukfor.reports.widgets.WidgetInstance;

public class SimpleHtmlReport
extends HtmlWidgetsReport {
    public static final String DEFAULT_LAYOUT = "/layouts/default";
    private String layout = "/layouts/default";
    private StringBuilder content = new StringBuilder();
    private String title = "Table Report";

    public SimpleHtmlReport() {
        super(DEFAULT_LAYOUT);
        this.importWidget("data_table");
    }

    public void title(String title) {
        this.title = title;
        this.add(this.tag("h1", title));
    }

    public void section(String section) {
        this.add(this.tag("h2", section));
    }

    public void text(String text) {
        this.add(this.tag("p", text));
    }

    public void code(String text) {
        this.add(this.tag("pre", this.tag("code", text)));
    }

    public void table(Object[] objects, String ... columns) {
        Gson gson = new Gson();
        Vector<JsonElement> data = new Vector<JsonElement>();
        for (int i = 0; i < objects.length; ++i) {
            data.add(gson.toJsonTree(objects[i]));
        }
        this.table(columns, data);
    }

    public void table(String[] header, List<JsonElement> objects) {
        Vector configColumns = new Vector();
        for (int i = 0; i < header.length; ++i) {
            HashMap<String, String> configColumn = new HashMap<String, String>();
            configColumn.put("data", "_" + i);
            configColumn.put("title", header[i]);
            configColumns.add(configColumn);
        }
        Vector dataObjects = new Vector();
        for (int i = 0; i < objects.size(); ++i) {
            HashMap<String, JsonElement> dataObject = new HashMap<String, JsonElement>();
            for (int j = 0; j < header.length; ++j) {
                dataObject.put("_" + j, objects.get(i).getAsJsonObject().get(header[j]));
            }
            dataObjects.add(dataObject);
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("columns", configColumns);
        config.put("data", dataObjects);
        this.widget("data_table", config);
    }

    public void plot(Object[] objects, String x, String y) {
        this.plot(objects, x, y, "markers");
    }

    public void plot(Object[] objects, String x, String y, String type) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        Gson gson = new Gson();
        Vector<Number> xData = new Vector<Number>();
        Vector<Number> yData = new Vector<Number>();
        for (int i = 0; i < objects.length; ++i) {
            JsonObject object = gson.toJsonTree(objects[i]).getAsJsonObject();
            xData.add(object.get(x).getAsNumber());
            yData.add(object.get(y).getAsNumber());
        }
        Vector traces = new Vector();
        HashMap<String, Object> trace = new HashMap<String, Object>();
        trace.put("x", xData);
        trace.put("y", yData);
        trace.put("mode", type);
        trace.put("type", type);
        traces.add(trace);
        config.put("traces", traces);
        HashMap layout = new HashMap();
        HashMap<String, String> xaxis = new HashMap<String, String>();
        xaxis.put("title", x);
        layout.put("xaxis", xaxis);
        HashMap<String, String> yaxis = new HashMap<String, String>();
        yaxis.put("title", y);
        layout.put("yaxis", yaxis);
        config.put("layout", layout);
        this.widget("plotly", config);
    }

    public void widget(String name, HashMap<String, Object> config) {
        IWidget widget = this.importWidget(name);
        WidgetInstance instance = widget.createInstance(config);
        this.addInstance(instance);
        this.content.append(instance.getHtml());
    }

    public void add(String tag) {
        this.content.append(tag);
    }

    public String tag(String tag, String content) {
        StringBuilder html = new StringBuilder();
        html.append("<");
        html.append(tag);
        html.append(">");
        html.append(content);
        html.append("</");
        html.append(tag);
        html.append(">");
        return html.toString();
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getLayout() {
        return this.layout;
    }

    public void save(String filename) throws IOException {
        this.generate(new File(filename));
    }

    public void saveAndOpen(String filename) throws IOException {
        this.save(filename);
        File htmlFile = new File(filename);
        Desktop.getDesktop().browse(htmlFile.toURI());
    }

    @Override
    public void generate(File outputFile) throws IOException {
        this.set("title", this.title);
        this.set("head", this.getHead());
        this.set("content", this.content.toString());
        this.set("date", new Date());
        super.generate(outputFile);
    }
}

