/*
 * Decompiled with CFR 0.152.
 */
package lukfor.reports.functions;

import java.util.function.Function;
import lukfor.reports.HtmlReport;
import lukfor.reports.util.FileUtil;

public class IncludeScriptFunction
implements Function<String, String> {
    private HtmlReport report;

    public IncludeScriptFunction(HtmlReport report) {
        this.report = report;
    }

    @Override
    public String apply(String url) {
        String source = "";
        if (url.startsWith("https://") || url.startsWith("http://")) {
            source = url;
        } else if (this.report.isSelfContained()) {
            System.out.println("  Include javascript " + url + "...");
            String content = this.report.renderTemplate(url);
            source = FileUtil.encodeBase64("text/javascript", content);
        } else {
            System.out.println("  Copy javascript " + url + " into assets...");
            try {
                source = this.report.renderTemplateAndCopyToAssets(url);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        StringBuilder html = new StringBuilder();
        html.append("<!-- " + url + " -->\n");
        html.append("<script src=\"" + source + "\"></script>");
        return html.toString();
    }
}

