/*
 * Decompiled with CFR 0.152.
 */
package lukfor.reports.functions;

import java.util.function.Function;
import lukfor.reports.HtmlReport;
import lukfor.reports.util.FileUtil;

public class IncludeStyleFunction
implements Function<String, String> {
    private HtmlReport report;

    public IncludeStyleFunction(HtmlReport report) {
        this.report = report;
    }

    @Override
    public String apply(String url) {
        String href = "";
        if (url.startsWith("https://") || url.startsWith("http://")) {
            href = url;
        } else if (this.report.isSelfContained()) {
            System.out.println("  Include style " + url + "...");
            String content = this.report.renderTemplate(url);
            href = FileUtil.encodeBase64("text/css", content);
        } else {
            System.out.println("  Copy style " + url + " into assets...");
            try {
                href = this.report.renderTemplateAndCopyToAssets(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        StringBuilder html = new StringBuilder();
        html.append("<!-- " + url + " -->\n");
        html.append("<link rel=\"stylesheet\" href=\"" + href + "\">");
        return html.toString();
    }
}

