/*
 * Decompiled with CFR 0.152.
 */
package lukfor.reports.functions.text;

import java.text.DecimalFormat;
import java.util.function.Function;

public class PercentageFunction
implements Function<Object, String> {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###.##'%'");

    @Override
    public String apply(Object number) {
        if (number instanceof Double) {
            double percentage = (Double)number * 100.0;
            return DECIMAL_FORMAT.format(percentage);
        }
        if (number instanceof Float) {
            double percentage = ((Float)number).floatValue() * 100.0f;
            return DECIMAL_FORMAT.format(percentage);
        }
        return "NaN%";
    }
}

