/*
 * Decompiled with CFR 0.152.
 */
package examples;

import genepi.io.table.reader.CsvTableReader;
import java.io.IOException;
import lukfor.tables.Table;
import lukfor.tables.columns.AbstractColumn;
import lukfor.tables.columns.IBuildValueFunction;
import lukfor.tables.columns.types.StringColumn;
import lukfor.tables.io.TableBuilder;
import lukfor.tables.io.TableWriter;
import lukfor.tables.rows.Row;
import lukfor.tables.rows.TableIndex;
import lukfor.tables.rows.filters.IRowFilter;

public class ExtractPositions {
    public static double BIN_SIZE = 0.01;

    public static void main(String[] args) throws IOException {
        String referencePos = "/media/lukas/data/projects/pain/gwas/data/GSA-GWA-backbone-position_build37.txt";
        String metaFilename = "/media/lukas/data/projects/pain/gwas/data/chr1.meta.csv";
        String output = "/media/lukas/data/projects/pain/gwas/data/cht1.meta.filterd.csv";
        Table positions = TableBuilder.fromCsvFile(referencePos).withSeparator('\t').load();
        positions.getRows().drop(new IRowFilter(){

            @Override
            public boolean accepts(Row row) {
                return row.getString("chr").equals("0");
            }
        });
        positions.getColumns().append(new StringColumn("snp"), new IBuildValueFunction(){

            @Override
            public Object buildValue(Row row) {
                return row.getObject("chr") + ":" + row.getObject("pos");
            }
        });
        positions.getRows().dropDuplicates();
        TableIndex index = positions.createIndex("snp");
        Table filtered = ExtractPositions.extractPositions(metaFilename, index);
        TableWriter.writeToCsv(filtered, output, '\t');
    }

    public static Table extractPositions(String filename, TableIndex positions) throws IOException {
        int keep = 0;
        int total = 0;
        if (filename.contains("chrX")) {
            return null;
        }
        int totalChromosome = 0;
        CsvTableReader reader = new CsvTableReader(filename, '\t');
        Table table = new Table("output");
        AbstractColumn chrColumn = table.getColumns().append(new StringColumn("chr"));
        AbstractColumn posColumn = table.getColumns().append(new StringColumn("pos"));
        while (reader.next()) {
            String chr = reader.getString("chr");
            String pos = reader.getString("pos");
            if (positions.getRow(String.valueOf(chr) + ":" + pos) != null) {
                chrColumn.add(chr);
                posColumn.add(pos);
                ++keep;
            }
            ++total;
            ++totalChromosome;
        }
        reader.close();
        System.out.println(String.valueOf(filename) + ": " + totalChromosome + " snps");
        System.out.println("Keep " + keep + "/" + total + " snps.");
        return table;
    }
}

