/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.IOException;
import java.util.Vector;
import lukfor.tables.Table;
import lukfor.tables.io.TableBuilder;
import lukfor.tables.io.TableWriter;
import lukfor.tables.rows.Row;
import lukfor.tables.rows.filters.IRowFilter;

public class FilterVariantsByRsq {
    public static void main(String[] args) throws IOException {
        String input = "/media/lukas/data/projects/pain/gwas/data/chr1.meta.csv";
        String output = "/media/lukas/data/projects/pain/gwas/data/chr1.meta.new.csv";
        final double rsq = 0.9;
        Table table = TableBuilder.fromCsvFile(input).withSeparator('\t').load();
        final Vector<String> columns = new Vector<String>();
        String[] stringArray = table.getColumns().getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            if (column.endsWith("_Rsq")) {
                columns.add(column);
            }
            ++n2;
        }
        System.out.println("Removing all where: ");
        for (String column : columns) {
            if (columns.get(0) != column) {
                System.out.print(" or ");
            }
            System.out.print(String.valueOf(column) + " < " + rsq);
        }
        System.out.println();
        table.getRows().drop(new IRowFilter(){

            @Override
            public boolean accepts(Row row) {
                for (String column : columns) {
                    if (!(row.getDouble(column) < rsq)) continue;
                    return true;
                }
                return false;
            }
        });
        TableWriter.writeToCsv(table, output, '\t');
    }
}

