/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.IOException;
import lukfor.tables.Table;
import lukfor.tables.io.TableBuilder;
import lukfor.tables.rows.IRowProcessor;
import lukfor.tables.rows.Row;
import lukfor.tables.rows.TableIndex;

public class GCKDCompareMapping2 {
    private String mappingAFilename = "/home/lukas/Askimed Dropbox/Lukas Forer/Genepi/Projekte/gckd/Mapping-File/20180425_1.1.1/GCKD-mapping-1.1.1.csv";
    private String mappingBFilename = "GCKD-mapping-2.0.0.csv";
    int diff = 0;

    public int call() throws IOException {
        Table mappingA = TableBuilder.fromCsvFile(this.mappingAFilename).withSeparator(';').withColumnTypeDetection(true).load();
        mappingA.printSummary();
        Table mappingB = TableBuilder.fromCsvFile(this.mappingBFilename).withSeparator(',').withColumnTypeDetection(true).load();
        mappingA.replaceValue(0, null);
        mappingB.printSummary();
        final TableIndex mappingBIndex = mappingB.createIndex("ASKIMED_ID");
        mappingA.forEachRow(new IRowProcessor(){

            @Override
            public void process(Row row) {
                String id = row.getString("ASKIMED_ID");
                Row row2 = mappingBIndex.getRow(id);
                if (row2 != null) {
                    if (!GCKDCompareMapping2.this.compare(id, row, row2, "BAYER_ID", "BAYER_ID")) {
                        ++GCKDCompareMapping2.this.diff;
                    }
                    if (!GCKDCompareMapping2.this.compare(id, row, row2, "BARCODE_ERLANGEN_SERUM_2", "BARCODE_ERLANGEN_SERUM_2")) {
                        ++GCKDCompareMapping2.this.diff;
                    }
                    if (!GCKDCompareMapping2.this.compare(id, row, row2, "BARCODE_IBK_SERUM_SET_A", "BARCODE_IBK_SERUM_SET_A")) {
                        ++GCKDCompareMapping2.this.diff;
                    }
                    if (!GCKDCompareMapping2.this.compare(id, row, row2, "BARCODE_IBK_SERUM_SET_B", "BARCODE_IBK_SERUM_SET_B")) {
                        ++GCKDCompareMapping2.this.diff;
                    }
                } else {
                    System.out.println("Id '" + id + "' no found in 1.1.1");
                }
            }
        });
        System.out.println("Differences: " + this.diff);
        return 0;
    }

    public boolean compare(String id, Row row1, Row row2, String column1, String column2) {
        Object value1 = row1.getObject(column1);
        Object value2 = row2.getObject(column2);
        if (value1 != null) {
            if (!value1.equals(value2)) {
                System.out.println("Id '" + id + "': " + column1 + ": " + value1 + " vs. " + value2);
                return false;
            }
        } else if (value2 != null) {
            System.out.println("Id '" + id + "': " + column1 + ": " + value1 + " vs. " + value2);
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        new GCKDCompareMapping2().call();
    }
}

