/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.IOException;
import lukfor.tables.Table;
import lukfor.tables.io.TableBuilder;
import lukfor.tables.io.TableWriter;

public class GCKDMapping {
    private String barcodesFilename = "/home/lukas/Askimed Dropbox/Lukas Forer/Genepi/Projekte/gckd/Mapping-File/20201022_2.0.0/data/Barcodes_20201022_v3.csv";
    private String bayerIdsFilename = "/home/lukas/Askimed Dropbox/Lukas Forer/Genepi/Projekte/gckd/Mapping-File/20201022_2.0.0/data/BayerIds.csv";
    private String serumBarcodesFilename = "/home/lukas/Askimed Dropbox/Lukas Forer/Genepi/Projekte/gckd/Mapping-File/20201022_2.0.0/data/20180425_GCKD_Seren_AundB.xls";
    private String dnaBarcodesFilename = "/home/lukas/Askimed Dropbox/Lukas Forer/Genepi/Projekte/gckd/Mapping-File/20201022_2.0.0/data/20180425_GCKD_DNA Codes.xls";

    private int call() throws IOException {
        Table barcodes = TableBuilder.fromCsvFile(this.barcodesFilename).withSeparator(',').withColumnTypeDetection(false).load();
        barcodes.getColumns().select("proband", "BL_lp_bb_ser2co", "BL_lp_gen_edtaco");
        barcodes.getColumns().rename("proband", "ASKIMED_ID");
        barcodes.getColumns().rename("BL_lp_bb_ser2co", "BARCODE_ERLANGEN_SERUM_2");
        barcodes.getColumns().rename("BL_lp_gen_edtaco", "BARCODE_ERLANGEN_DNA");
        barcodes.printSummary();
        Table bayerIds = TableBuilder.fromCsvFile(this.bayerIdsFilename).withSeparator(',').withColumnTypeDetection(false).load();
        bayerIds.getColumns().select("MNPPSD", "BAYER_ID");
        bayerIds.getRows().dropDuplicates();
        bayerIds.printSummary();
        Table serumBarcodes = TableBuilder.fromXlsFile(this.serumBarcodesFilename).withColumnTypeDetection(false).load();
        serumBarcodes.getColumns().rename("NAME (=Barcode Urspungs-Probe)", "BARCODE_ERLANGEN_SERUM_2");
        serumBarcodes.getColumns().rename("GCKD_Serum_A_Tube-Barcode", "BARCODE_IBK_SERUM_SET_A");
        serumBarcodes.getColumns().rename("GCKD_Serum_B_Tube-Barcode", "BARCODE_IBK_SERUM_SET_B");
        serumBarcodes.getColumns().select("BARCODE_ERLANGEN_SERUM_2", "BARCODE_IBK_SERUM_SET_A", "BARCODE_IBK_SERUM_SET_B");
        Table dnaBarcodes = TableBuilder.fromXlsFile(this.dnaBarcodesFilename).withColumnTypeDetection(false).load();
        dnaBarcodes.getColumns().rename("DNA_ID", "BARCODE_ERLANGEN_DNA");
        dnaBarcodes.getColumns().rename("IBK_DNA_Tube-Barcode", "BARCODE_IBK_DNA");
        dnaBarcodes.getRows().dropByRegEx("BARCODE_ERLANGEN_DNA", "NTC");
        dnaBarcodes.print();
        barcodes.merge(bayerIds, "ASKIMED_ID", "MNPPSD");
        barcodes.merge(serumBarcodes, "BARCODE_ERLANGEN_SERUM_2");
        barcodes.print();
        barcodes.printSummary();
        TableWriter.writeToCsv(barcodes, "GCKD-mapping-2.0.0.csv");
        return 0;
    }

    public static void main(String[] args) throws IOException {
        new GCKDMapping().call();
    }
}

