/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.text.SimpleDateFormat;
import java.util.Date;
import lukfor.tables.Table;
import lukfor.tables.columns.IBuildValueFunction;
import lukfor.tables.columns.types.DoubleColumn;
import lukfor.tables.columns.types.StringColumn;
import lukfor.tables.io.TableBuilder;
import lukfor.tables.io.TableWriter;
import lukfor.tables.rows.Row;

public class GckdCalculateAnzahlStundenNew {
    public static void main(String[] args) {
        String input = "/home/lukas/Downloads/20190724_FK_Probenentnahme_20190724_v1.csv";
        String output = "lf.xls";
        String[] visits = new String[]{"BL", "FU2", "FU3", "FU4"};
        try {
            Table table = TableBuilder.fromCsvFile(input).withSeparator(',').withColumnTypeDetection(false).load();
            String[] stringArray = visits;
            int n = visits.length;
            int n2 = 0;
            while (n2 < n) {
                String visite = stringArray[n2];
                table.getColumns().append(new StringColumn(String.valueOf(visite) + "_blutabn_zeit"), new BlutabnZeitBuilder(String.valueOf(visite) + "_psn_datuhr"));
                table.getColumns().append(new DoubleColumn(String.valueOf(visite) + "_anzahl_stunden"), new AnzahlStundenBuilder(String.valueOf(visite) + "_psn_datuhr", String.valueOf(visite) + "_psn_essen_uhr"));
                ++n2;
            }
            TableWriter.writeToXls(table, output);
            table.printSummary();
            Table test = table.clone();
            test.getColumns().selectByRegEx(".*_anzahl_stunden|proband");
            test.print();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class AnzahlStundenBuilder
    implements IBuildValueFunction {
        private String psnDatUhr;
        private String psnEssenUhr;

        public AnzahlStundenBuilder(String psnDatUhr, String psnEssenUhr) {
            this.psnDatUhr = psnDatUhr;
            this.psnEssenUhr = psnEssenUhr;
        }

        @Override
        public Object buildValue(Row row) {
            Double value = null;
            String date = row.getString(this.psnDatUhr);
            if (date != null && !date.isEmpty()) {
                SimpleDateFormat secutrialFormatComplete = new SimpleDateFormat("yyyyMMddHHmm");
                try {
                    Date d = secutrialFormatComplete.parse(date);
                    String time = row.getString(this.psnEssenUhr);
                    if (time != null && !time.isEmpty()) {
                        int hoursEssen = 0;
                        int minEssen = 0;
                        hoursEssen = Integer.parseInt(time.substring(0, 2));
                        minEssen = Integer.parseInt(time.substring(3, 5));
                        int hoursAbnahme = d.getHours();
                        int minAbnahm = d.getMinutes();
                        boolean gleicherTag = true;
                        if (hoursAbnahme < hoursEssen) {
                            gleicherTag = false;
                        } else if (hoursAbnahme == hoursEssen && minAbnahm < minEssen) {
                            gleicherTag = false;
                        }
                        if (!gleicherTag) {
                            hoursAbnahme += 24;
                        }
                        value = (double)hoursAbnahme + (double)minAbnahm / 60.0 - ((double)hoursEssen + (double)minEssen / 60.0);
                    } else {
                        value = null;
                    }
                }
                catch (Exception e) {
                    value = null;
                }
            }
            return value;
        }
    }

    static class BlutabnZeitBuilder
    implements IBuildValueFunction {
        private String psnDatUhr;

        public BlutabnZeitBuilder(String psnDatUhr) {
            this.psnDatUhr = psnDatUhr;
        }

        @Override
        public Object buildValue(Row row) {
            String value = "";
            String date = row.getString(this.psnDatUhr);
            if (date != null && !date.isEmpty()) {
                SimpleDateFormat secutrialFormatComplete = new SimpleDateFormat("yyyyMMddHHmm");
                try {
                    Date d = secutrialFormatComplete.parse(date);
                    int hoursAbnahme = d.getHours();
                    int minAbnahm = d.getMinutes();
                    value = String.valueOf(hoursAbnahme < 10 ? "0" : "") + hoursAbnahme + ":" + (minAbnahm < 10 ? "0" : "") + minAbnahm;
                }
                catch (Exception e) {
                    value = "";
                }
            }
            return value;
        }
    }
}

