/*
 * Decompiled with CFR 0.152.
 */
package examples;

import genepi.io.FileUtil;
import genepi.io.table.reader.CsvTableReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import lukfor.tables.Table;
import lukfor.tables.columns.AbstractColumn;
import lukfor.tables.columns.types.StringColumn;
import lukfor.tables.io.TableWriter;
import lukfor.tables.rows.Row;
import lukfor.tables.rows.TableIndex;

public class MergeInfosFinal {
    public static double BIN_SIZE = 0.01;
    private String output = "/media/lukas/data/projects/pain/gwas/data/chr1.meta.csv";
    private String[] infos = new String[]{"/media/lukas/data/projects/pain/gwas/data/koras4/info/chr1.info.gz", "/media/lukas/data/projects/pain/gwas/data/koras3/info/chr1.info.gz", "/media/lukas/data/projects/pain/gwas/data/pain/genotypes/imputed/info/chr1.info.gz"};
    private String[] labels = new String[]{"koras4", "koras3", "pain"};

    public static void main(String[] args) throws IOException {
        new MergeInfosFinal().run();
    }

    public void run() throws IOException {
        assert (this.infos.length > 0);
        assert (this.infos.length == this.labels.length);
        Table positions = MergeInfosFinal.loadPositionsFromInfoFile(this.infos[0]);
        int i = 0;
        while (i < this.infos.length) {
            MergeInfosFinal.mergeWithPositions(positions, this.infos[i], this.labels[i]);
            ++i;
        }
        positions.getColumns().drop("index");
        TableWriter.writeToCsv(positions, this.output, '\t');
    }

    public static Table loadPositionsFromInfoFile(String referencePos) throws IOException {
        FileInputStream inputStream = new FileInputStream(referencePos);
        InputStream in2 = FileUtil.decompressStream((InputStream)inputStream);
        CsvTableReader reader = new CsvTableReader(new DataInputStream(in2), '\t');
        Table positions = new Table(referencePos);
        AbstractColumn indexColumn = positions.getColumns().append(new StringColumn("index"));
        AbstractColumn chrColumn = positions.getColumns().append(new StringColumn("chr"));
        AbstractColumn posColumn = positions.getColumns().append(new StringColumn("pos"));
        AbstractColumn refColumn = positions.getColumns().append(new StringColumn("ref"));
        AbstractColumn altColumn = positions.getColumns().append(new StringColumn("alt"));
        while (reader.next()) {
            String snp = reader.getString("snp");
            String[] tiles = snp.split(":");
            chrColumn.add(tiles[0]);
            posColumn.add(tiles[1]);
            String ref = reader.getString("ref(0)");
            refColumn.add(ref);
            String alt = reader.getString("alt(1)");
            altColumn.add(alt);
            indexColumn.add(String.valueOf(snp) + "_" + ref + "_" + alt);
        }
        reader.close();
        return positions;
    }

    public static void mergeWithPositions(Table positions, String filename, String label) throws IOException {
        System.out.println("Loading file '" + filename + "' with label " + label);
        TableIndex index = positions.createIndex("index");
        AbstractColumn rsqColumn = positions.getColumns().append(new StringColumn(String.valueOf(label) + "_Rsq"));
        AbstractColumn mafColumn = positions.getColumns().append(new StringColumn(String.valueOf(label) + "_MAF"));
        AbstractColumn genotypedColumn = positions.getColumns().append(new StringColumn(String.valueOf(label) + "_Genotyped"));
        int keep = 0;
        int total = 0;
        if (filename.contains("chrX")) {
            return;
        }
        FileInputStream inputStream = new FileInputStream(filename);
        InputStream in2 = FileUtil.decompressStream((InputStream)inputStream);
        CsvTableReader reader = new CsvTableReader(new DataInputStream(in2), '\t');
        while (reader.next()) {
            String snp = reader.getString("snp");
            String ref = reader.getString("ref(0)");
            String alt = reader.getString("alt(1)");
            Row posRow = index.getRow(String.valueOf(snp) + "_" + ref + "_" + alt);
            if (posRow != null) {
                rsqColumn.set(posRow.getIndex(), reader.getString("Rsq"));
                mafColumn.set(posRow.getIndex(), reader.getString("MAF"));
                int genotyped = reader.getString("Genotyped").equals("Genotyped") ? 1 : 0;
                genotypedColumn.set(posRow.getIndex(), genotyped);
                ++keep;
            }
            ++total;
        }
        reader.close();
        System.out.println("Loaded " + filename + ". Use " + keep + "/" + total + " snps");
    }
}

