/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.IOException;
import java.util.Vector;
import lukfor.tables.Table;
import lukfor.tables.columns.IBuildValueFunction;
import lukfor.tables.columns.types.StringColumn;
import lukfor.tables.io.TableBuilder;
import lukfor.tables.io.TableWriter;
import lukfor.tables.rows.IRowProcessor;
import lukfor.tables.rows.Row;

public class MergeMutipleInfos {
    public static void main(String[] args) throws IOException {
        Table table = MergeMutipleInfos.mergeInfos(new String[]{"/media/lukas/data/projects/pain/gwas/data/koras4/info/chr1.info.gz", "/media/lukas/data/projects/pain/gwas/data/koras3/info/chr1.info.gz", "/media/lukas/data/projects/pain/gwas/data/pain/genotypes/imputed/info/chr1.info.gz"});
        table.print();
        final Table output = new Table("positions");
        output.getColumns().append(new StringColumn("chr"));
        output.getColumns().append(new StringColumn("pos"));
        table.forEachRow(new IRowProcessor(){

            @Override
            public void process(Row row) {
                String snp = row.getString("SNP");
                Object[] tiles = snp.split(":");
                Row newRow = output.getRows().append();
                newRow.set(tiles);
            }
        });
        TableWriter.writeToCsv(output, "/media/lukas/data/projects/pain/gwas/data/pain_koras3_koras4/snps/chr1.txt", '\t');
    }

    public static Table mergeInfos(String[] files) throws IOException {
        final Table[] tables = new Table[files.length];
        int i = 0;
        while (i < tables.length) {
            tables[i] = TableBuilder.fromCsvFile(files[i]).withSeparator('\t').withColumnTypeDetection(false).load();
            ++i;
        }
        final Vector<Boolean> badQuality = new Vector<Boolean>(tables[0].getRows().getSize());
        int i2 = 1;
        while (i2 < tables.length) {
            final Table table = tables[i2];
            tables[0].getColumns().append(new StringColumn("Rsq_" + i2), new IBuildValueFunction(){

                @Override
                public Object buildValue(Row row) {
                    int index = row.getIndex();
                    return table.get(index, "Rsq");
                }
            });
            ++i2;
        }
        tables[0].getColumns().append(new StringColumn("Rsq_min"), new IBuildValueFunction(){

            @Override
            public Object buildValue(Row row) {
                int index = row.getIndex();
                double min = Double.MAX_VALUE;
                int i = 0;
                while (i < tables.length) {
                    Double value = Double.parseDouble(tables[i].get(index, "Rsq").toString());
                    if (value < min) {
                        min = value;
                    }
                    ++i;
                }
                badQuality.add(min < 0.8);
                return String.format("%.5f", min);
            }
        });
        tables[0].getRows().drop(badQuality);
        return tables[0];
    }
}

