/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables;

import java.util.List;
import java.util.Vector;
import lukfor.tables.Table;
import lukfor.tables.columns.AbstractColumn;
import lukfor.tables.columns.ColumnSorter;
import lukfor.tables.rows.IRowProcessor;
import lukfor.tables.rows.Row;
import lukfor.tables.rows.filters.IRowFilter;
import lukfor.tables.rows.filters.RowValueRegExFilter;
import lukfor.tables.rows.processors.RowDuplicateProcessor;
import lukfor.tables.rows.processors.RowSelectionProcessor;

public class RowOperations {
    private Table table;

    public RowOperations(Table table) {
        this.table = table;
    }

    public Row get(int index) {
        Row row = new Row(this.table, index);
        return row;
    }

    public List<Row> getAll(final String column, final Object value) {
        return this.getAll(new IRowFilter(){

            @Override
            public boolean accepts(Row row) {
                Object valueRow = row.getObject(column);
                return valueRow.equals(value);
            }
        });
    }

    public List<Row> getAllByRegEx(final String column, final String value) {
        return this.getAll(new IRowFilter(){

            @Override
            public boolean accepts(Row row) {
                String valueRow = row.getObject(column).toString();
                return valueRow.matches(value);
            }
        });
    }

    public List<Row> getAll(final IRowFilter filter) {
        final Vector<Row> results = new Vector<Row>();
        this.table.forEachRow(new IRowProcessor(){

            @Override
            public void process(Row row) {
                if (filter.accepts(row)) {
                    results.add(row);
                }
            }
        });
        return results;
    }

    public Row append() {
        for (AbstractColumn column : this.table.storage) {
            column.add(null);
        }
        int index = this.table.getRows().getSize() - 1;
        return new Row(this.table, index);
    }

    public void sortBy(String column) {
        this.sortBy(column, 1);
    }

    public void sortAscBy(String column) {
        this.sortBy(column, 1);
    }

    public void sortDescBy(String column) {
        this.sortBy(column, -1);
    }

    public void sortBy(String column, int order) {
        this.table.assertsColumnExists(column);
        ColumnSorter processor = new ColumnSorter(this.table.getColumns().get(column), order);
        for (AbstractColumn columnr : this.table.storage) {
            columnr.sort(processor.getIndices());
        }
    }

    public void dropByRegEx(String column, String regExp) throws RuntimeException {
        this.drop(new RowValueRegExFilter(column, regExp));
    }

    public void drop(IRowFilter filter) throws RuntimeException {
        RowSelectionProcessor processor = new RowSelectionProcessor(filter);
        this.table.forEachRow(processor);
        this.drop(processor.getBitmask());
    }

    public void drop(List<Boolean> bitmask) throws RuntimeException {
        Table.log(this.table, "Droping rows...");
        int rowsBefore = this.getSize();
        for (AbstractColumn column : this.table.storage) {
            column.drop(bitmask);
        }
        int rowsAfter = this.getSize();
        Table.log(this.table, "#Rows before: " + rowsBefore);
        Table.log(this.table, "#Rows after: " + rowsAfter);
        Table.log(this.table, "Droped rows.");
    }

    public void dropDuplicates() {
        RowDuplicateProcessor processor = new RowDuplicateProcessor();
        this.table.forEachRow(processor);
        this.drop(processor.getBitmask());
    }

    public void dropMissings() {
        IRowFilter filter = new IRowFilter(){

            @Override
            public boolean accepts(Row row) {
                return row.hasMissings();
            }
        };
        RowSelectionProcessor processor = new RowSelectionProcessor(filter);
        this.table.forEachRow(processor);
        this.drop(processor.getBitmask());
    }

    public void dropMissings(final String column) {
        IRowFilter filter = new IRowFilter(){

            @Override
            public boolean accepts(Row row) {
                return row.getObject(column) == null;
            }
        };
        RowSelectionProcessor processor = new RowSelectionProcessor(filter);
        this.table.forEachRow(processor);
        this.drop(processor.getBitmask());
    }

    public void selectByRegEx(String column, String regExp) {
        this.select(new RowValueRegExFilter(column, regExp));
    }

    public void select(IRowFilter filter) {
        RowSelectionProcessor processor = new RowSelectionProcessor(filter);
        this.table.forEachRow(processor);
        this.select(processor.getBitmask());
    }

    public void select(List<Boolean> bitmask) {
        Table.log(this.table, "Filtering rows...");
        int rowsBefore = this.getSize();
        for (AbstractColumn column : this.table.storage) {
            column.select(bitmask);
        }
        int rowsAfter = this.getSize();
        Table.log(this.table, "#Rows before: " + rowsBefore);
        Table.log(this.table, "#Rows after: " + rowsAfter);
        Table.log(this.table, "Filtered table.");
    }

    public int getSize() {
        this.table.assertsNotEmpty();
        return this.table.storage.get(0).getSize();
    }

    public String[][] data() {
        return this.data(0, this.getSize() - 1);
    }

    public String[][] data(int start, int end) throws RuntimeException {
        int height = end - start + 1;
        int width = this.table.getColumns().getSize() + 1;
        String[][] data = new String[height][];
        for (int i = 0; i < height; ++i) {
            data[i] = new String[width];
            data[i][0] = i + start + 1 + "";
            for (int j = 0; j < width - 1; ++j) {
                String string;
                Object value = this.table.getColumn(j).get(i + start);
                data[i][j + 1] = string = this.table.getColumn(j).objectToValue(value);
            }
        }
        return data;
    }

    public void clear() {
    }
}

