/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import lukfor.reports.HtmlWidgetsReport;
import lukfor.reports.widgets.IWidget;
import lukfor.reports.widgets.WidgetInstance;
import lukfor.tables.Table;
import lukfor.tables.plotly.Trace;
import lukfor.tables.plotly.TraceList;
import lukfor.tables.rows.Row;

public class TableReport
extends HtmlWidgetsReport {
    public static final String DEFAULT_TEMPLATE = "/templates/default";
    private String template = "/templates/default";
    private StringBuilder content = new StringBuilder();
    private String title = "Table Report";
    private String filename = "";

    public TableReport(String filename) {
        super(DEFAULT_TEMPLATE);
        this.filename = filename;
        this.importWidget("data_table");
    }

    public void title(String title) {
        this.title = title;
        this.add(this.tag("h1", title));
    }

    public void section(String section) {
        this.add(this.tag("h2", section));
    }

    public void text(String text) {
        this.add(this.tag("p", text));
    }

    public void code(String text) {
        this.add(this.tag("pre", this.tag("code", text)));
    }

    public void table(Table table) {
        this.table(table, table.getColumns().getNames());
    }

    public void table(Table table, String ... columns) {
        Vector configColumns = new Vector();
        int i = 0;
        while (i < columns.length) {
            HashMap<String, String> configColumn = new HashMap<String, String>();
            configColumn.put("data", "_" + i);
            configColumn.put("title", columns[i]);
            configColumns.add(configColumn);
            ++i;
        }
        Vector data = new Vector();
        int i2 = 0;
        while (i2 < table.getRows().getSize()) {
            HashMap<String, Object> dataObject = new HashMap<String, Object>();
            int j = 0;
            while (j < columns.length) {
                dataObject.put("_" + j, table.get(i2, columns[j]));
                ++j;
            }
            data.add(dataObject);
            ++i2;
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("columns", configColumns);
        config.put("data", data);
        this.widget("data_table", config);
    }

    public void plot(Table table, String x, String y) {
        this.plot(table, x, y, "markers");
    }

    public void plot(Table table, String x, String y, String type) {
        this.plot(table, x, y, type, null);
    }

    public void plot(Table table, String x, String y, String type, String group) {
        TraceList traces = new TraceList();
        int i = 0;
        while (i < table.getRows().getSize()) {
            Row row = table.getRow(i);
            Object value = table.getName();
            if (group != null) {
                value = row.getObject(group);
            }
            if (value != null) {
                Trace trace = traces.getByName(value.toString());
                trace.setMode(type);
                trace.setType(type);
                trace.addPoint((Number)row.getObject(x), (Number)row.getObject(y));
            }
            ++i;
        }
        this.plot(traces, x, y);
    }

    public void plot(Collection<Table> tables, String x, String y) {
        this.plot(tables, x, y, "markers");
    }

    public void plot(Collection<Table> tables, String x, String y, String type) {
        TraceList traces = this.createTraces(tables, x, y, type);
        this.plot(traces, x, y);
    }

    private TraceList createTraces(Collection<Table> tables, String x, String y, String type) {
        TraceList traces = new TraceList();
        for (Table table : tables) {
            Trace trace = traces.getByName(table.getName());
            trace.setMode(type);
            trace.setType(type);
            trace.setX(table.getColumn(x).getValues());
            trace.setY(table.getColumn(y).getValues());
        }
        return traces;
    }

    public void plot(TraceList traces, String x, String y) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("traces", traces.getTraces());
        HashMap layout = new HashMap();
        HashMap<String, String> xaxis = new HashMap<String, String>();
        xaxis.put("title", x);
        layout.put("xaxis", xaxis);
        HashMap<String, String> yaxis = new HashMap<String, String>();
        yaxis.put("title", y);
        layout.put("yaxis", yaxis);
        config.put("layout", layout);
        this.widget("plotly", config);
    }

    public void plotBar(Table table, String x, String y) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        HashMap<String, Object> trace = new HashMap<String, Object>();
        trace.put("x", table.getColumn(x).getValues());
        trace.put("y", table.getColumn(y).getValues());
        trace.put("mode", "bar");
        trace.put("type", "bar");
        config.put("traces", new Object[]{trace});
        HashMap layout = new HashMap();
        HashMap<String, String> xaxis = new HashMap<String, String>();
        xaxis.put("title", x);
        layout.put("xaxis", xaxis);
        HashMap<String, String> yaxis = new HashMap<String, String>();
        yaxis.put("title", y);
        layout.put("yaxis", yaxis);
        config.put("layout", layout);
        this.widget("plotly", config);
    }

    public void hist(Table table, String column, double bin) throws IOException {
        Table hist = table.hist(column, bin);
        this.plotBar(hist, column, "count");
    }

    public void widget(String name, HashMap<String, Object> config) {
        IWidget widget = this.importWidget(name);
        WidgetInstance instance = widget.createInstance(config);
        this.addInstance(instance);
        this.content.append(instance.getHtml());
    }

    public void add(String tag) {
        this.content.append(tag);
    }

    public String tag(String tag, String content) {
        StringBuilder html = new StringBuilder();
        html.append("<");
        html.append(tag);
        html.append(">");
        html.append(content);
        html.append("</");
        html.append(tag);
        html.append(">");
        return html.toString();
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public void save() throws IOException {
        this.generate(new File(this.filename));
    }

    public void saveAndOpen() throws IOException {
        this.save();
        File htmlFile = new File(this.filename);
        Desktop.getDesktop().browse(htmlFile.toURI());
    }

    public void generate(File outputFile) throws IOException {
        this.set("title", this.title);
        this.set("head", this.getHead());
        this.set("content", this.content.toString());
        this.set("date", new Date());
        super.generate(outputFile);
    }
}

