/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables.columns;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import lukfor.tables.columns.ColumnType;
import lukfor.tables.columns.IApplyFunction;
import lukfor.tables.exceptions.TableException;

public abstract class AbstractColumn {
    protected List<Object> storage;
    private String name;

    public AbstractColumn(int initSize) {
        this.storage = new Vector<Object>(initSize);
    }

    public void copyDataFrom(AbstractColumn column) {
        for (int i = 0; i < column.getSize(); ++i) {
            Object object = column.get(i);
            if (object != null) {
                this.storage.add(this.valueToObject(object.toString()));
                continue;
            }
            this.storage.add(null);
        }
    }

    public void replaceDataFrom(AbstractColumn column) {
        for (int i = 0; i < column.getSize(); ++i) {
            Object object = column.get(i);
            if (object != null) {
                this.storage.set(i, this.valueToObject(object.toString()));
                continue;
            }
            this.storage.set(i, null);
        }
    }

    public List<Number> getValues() {
        Vector<Number> numbers = new Vector<Number>();
        for (int i = 0; i < this.getSize(); ++i) {
            Object object = this.get(i);
            numbers.add((Number)object);
        }
        return numbers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract ColumnType getType();

    public void set(int index, Object data) {
        if (this.isMissingValue(data)) {
            this.storage.set(index, null);
        } else if (this.accepts(data)) {
            this.storage.set(index, data);
        } else {
            throw new RuntimeException("Object in column " + this.name + " [" + this.getClass() + "] has wrong class: " + data.getClass());
        }
    }

    public abstract boolean accepts(Object var1);

    public abstract Object valueToObject(String var1);

    public abstract String objectToValue(Object var1);

    public void add(Object data) {
        if (this.isMissingValue(data)) {
            this.storage.add(null);
        } else if (this.accepts(data)) {
            this.storage.add(data);
        } else {
            throw new RuntimeException("Object in column  [" + this.getClass() + "] has wrong class: " + data.getClass());
        }
    }

    public Object get(int index) {
        if (index < this.storage.size()) {
            return this.storage.get(index);
        }
        return null;
    }

    public int getSize() {
        return this.storage.size();
    }

    public void drop(List<Boolean> bitmask) {
        Vector<Object> newStorage = new Vector<Object>();
        for (int i = 0; i < this.storage.size(); ++i) {
            if (bitmask.get(i).booleanValue()) continue;
            newStorage.add(this.storage.get(i));
        }
        this.storage.clear();
        this.storage.addAll(newStorage);
        newStorage.clear();
    }

    public void select(List<Boolean> bitmask) {
        Vector<Object> newStorage = new Vector<Object>();
        for (int i = 0; i < this.storage.size(); ++i) {
            if (!bitmask.get(i).booleanValue()) continue;
            newStorage.add(this.storage.get(i));
        }
        this.storage.clear();
        this.storage.addAll(newStorage);
        newStorage.clear();
    }

    public void sort(List<Integer> indices) {
        Vector<Object> newStorage = new Vector<Object>();
        for (int i = 0; i < indices.size(); ++i) {
            int index = indices.get(i);
            Object value = this.storage.get(index);
            newStorage.add(value);
        }
        this.storage.clear();
        this.storage.addAll(newStorage);
        newStorage.clear();
    }

    public abstract int compare(Object var1, Object var2);

    public String toString() {
        return this.name + " [" + (Object)((Object)this.getType()) + "]";
    }

    public void fillMissings(Object value) {
        for (int i = 0; i < this.storage.size(); ++i) {
            if (this.storage.get(i) != null) continue;
            this.storage.set(i, value);
        }
    }

    public void apply(IApplyFunction function) {
        for (int i = 0; i < this.storage.size(); ++i) {
            Object value = this.storage.get(i);
            Object newValue = function.apply(value);
            this.storage.set(i, newValue);
        }
    }

    public void replaceValue(Object oldValue, Object newValue) {
        this.replaceValue(new Object[]{oldValue}, new Object[]{newValue});
    }

    public void replaceValue(Object[] oldValues, Object[] newValues) {
        if (oldValues.length != newValues.length) {
            throw new TableException("Arrays 'oldValues' and 'newValues' have different length.");
        }
        for (int i = 0; i < this.storage.size(); ++i) {
            Object value = this.storage.get(i);
            for (int j = 0; j < oldValues.length; ++j) {
                Object oldValue = oldValues[j];
                Object newValue = newValues[j];
                if (value == null && oldValue == null) {
                    this.storage.set(i, newValue);
                    continue;
                }
                if (value == null || !value.equals(oldValue)) continue;
                this.storage.set(i, newValue);
            }
        }
    }

    public int getMissings() {
        int missings = 0;
        for (int i = 0; i < this.storage.size(); ++i) {
            if (this.storage.get(i) != null) continue;
            ++missings;
        }
        return missings;
    }

    public int getUniqueValues() {
        HashSet<Integer> uniques = new HashSet<Integer>();
        for (int i = 0; i < this.storage.size(); ++i) {
            Object value = this.storage.get(i);
            if (value == null) continue;
            int hash = value.hashCode();
            uniques.add(hash);
        }
        return uniques.size();
    }

    public Object getSum() {
        return null;
    }

    public Object getMean() {
        return null;
    }

    public Object getMin() {
        return null;
    }

    public Object getMax() {
        return null;
    }

    public Object getSd() {
        return null;
    }

    public String getSummary() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            PrintStream ps = new PrintStream((OutputStream)baos, true, "UTF-8");
            this.printSummary(ps);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    public void printSummary() {
        this.printSummary(System.out);
    }

    public void printSummary(PrintStream out) {
        Object max;
        Object mean;
        out.println(this.name + " [" + (Object)((Object)this.getType()) + "] :");
        int missings = this.getMissings();
        out.println("  N: " + (this.getSize() - missings));
        out.println("  Missings: " + missings);
        Object min = this.getMin();
        if (min != null) {
            out.println("  Min.: " + min);
        }
        if ((mean = this.getMean()) != null) {
            out.println("  Mean.: " + mean);
        }
        if ((max = this.getMax()) != null) {
            out.println("  Max.: " + max);
        }
    }

    public abstract boolean isMissingValue(Object var1);

    public abstract AbstractColumn cloneStructure();
}

