/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables.columns.types;

import java.text.NumberFormat;
import java.util.Locale;
import lukfor.tables.columns.AbstractColumn;
import lukfor.tables.columns.ColumnType;

public class DoubleColumn
extends AbstractColumn {
    public static NumberFormat FORMAT = NumberFormat.getInstance(new Locale("en", "US"));

    public DoubleColumn(String name) {
        this(name, 100);
    }

    public DoubleColumn(String name, int capacity) {
        super(capacity);
        this.setName(name);
    }

    @Override
    public ColumnType getType() {
        return ColumnType.DOUBLE;
    }

    @Override
    public Object valueToObject(String data) {
        if (data.equals(".") || data.equals("") || data.equalsIgnoreCase("NA") || data.equalsIgnoreCase("NaN") || data.equals("*")) {
            return null;
        }
        return Double.parseDouble(data);
    }

    @Override
    public String objectToValue(Object data) {
        if (data != null) {
            return FORMAT.format(data);
        }
        return "";
    }

    @Override
    public int compare(Object value1, Object value2) {
        if (value1 == null) {
            value1 = Double.MIN_VALUE;
        }
        if (value2 == null) {
            value2 = Double.MIN_VALUE;
        }
        return ((Double)value1).compareTo((Double)value2);
    }

    @Override
    public boolean accepts(Object data) {
        return data instanceof Double;
    }

    @Override
    public Object getSum() {
        double sum = 0.0;
        for (Object o : this.storage) {
            if (o == null) continue;
            Double d = (Double)o;
            sum += d.doubleValue();
        }
        return sum;
    }

    @Override
    public Object getMean() {
        double sum = 0.0;
        int count = 0;
        for (Object o : this.storage) {
            if (o == null) continue;
            Double d = (Double)o;
            sum += d.doubleValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public Object getMin() {
        double min = Double.MAX_VALUE;
        for (Object o : this.storage) {
            Double d;
            if (o == null || !((d = (Double)o) < min)) continue;
            min = d;
        }
        return min;
    }

    @Override
    public Object getMax() {
        double max = Double.MIN_VALUE;
        for (Object o : this.storage) {
            Double d;
            if (o == null || !((d = (Double)o) > max)) continue;
            max = d;
        }
        return max;
    }

    @Override
    public Object getSd() {
        double mean = (Double)this.getMean();
        int count = 0;
        double sum = 0.0;
        for (Object o : this.storage) {
            if (o == null) continue;
            Double d = (Double)o;
            ++count;
            sum += Math.pow(d - mean, 2.0);
        }
        return Math.sqrt(sum / (double)count);
    }

    @Override
    public AbstractColumn cloneStructure() {
        return new DoubleColumn(this.getName());
    }

    @Override
    public boolean isMissingValue(Object object) {
        return object == null || object.toString().isEmpty();
    }

    static {
        FORMAT.setGroupingUsed(false);
        FORMAT.setMinimumFractionDigits(3);
        FORMAT.setMaximumFractionDigits(3);
    }
}

