/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables.rows;

import lukfor.tables.Table;
import lukfor.tables.columns.types.DoubleColumn;

public class Row {
    private Table table;
    private int index;

    public Row(Table table, int index) {
        this.table = table;
        this.index = index;
    }

    public void updateView(Table table, int index) {
        this.table = table;
        this.index = index;
    }

    public void fill(Row row) {
        for (String column : row.table.getColumns().getNames()) {
            this.set(column, row.getObject(column));
        }
    }

    public Object getObject(String column) {
        return this.table.get(this.index, column);
    }

    public String getString(String column) {
        return (String)this.getObject(column);
    }

    public int getInteger(String column) {
        return (Integer)this.getObject(column);
    }

    public double getDouble(String column) {
        return (Double)this.getObject(column);
    }

    public Object getObject(int column) {
        return this.table.get(this.index, column);
    }

    public String getString(int column) {
        return (String)this.getObject(column);
    }

    public int getInteger(int column) {
        return (Integer)this.getObject(column);
    }

    public double getDouble(int column) {
        return (Double)this.getObject(column);
    }

    public void set(String column, Object value) {
        this.table.getColumn(column).set(this.index, value);
    }

    public void set(int column, Object value) {
        this.table.getColumn(column).set(this.index, value);
    }

    public void set(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.table.getColumn(i).set(this.index, values[i]);
        }
    }

    public void setString(String column, Object value) {
        if (value != null) {
            if (value instanceof Double) {
                value = DoubleColumn.FORMAT.format(value);
            }
            this.table.getColumn(column).set(this.index, value.toString());
        } else {
            this.table.getColumn(column).set(this.index, null);
        }
    }

    public boolean hasMissings() {
        for (int i = 0; i < this.table.getColumns().getSize(); ++i) {
            if (this.table.get(this.index, i) != null) continue;
            return true;
        }
        return false;
    }

    public int getHashCode() {
        int result = 1;
        for (int i = 0; i < this.table.getColumns().getSize(); ++i) {
            Object element = this.table.get(this.index, i);
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public int getIndex() {
        return this.index;
    }
}

