/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import lukfor.tables.script.MarkdownScriptEngine;
import lukfor.tables.script.ScriptEngine;
import org.codehaus.groovy.control.CompilationFailedException;

public class App {
    public int run(String[] args) throws CompilationFailedException, IOException, ClassNotFoundException {
        if (args.length < 1) {
            System.out.println("Please specify input file");
            return -1;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 1;
        while (i < args.length) {
            String name = args[i].replaceAll("--", "");
            String value = args[i + 1];
            params.put(name, value);
            i += 2;
        }
        String filename = args[0];
        File script = new File(filename);
        if (!script.exists()) {
            System.out.println("File '" + filename + "' not found.");
            return -1;
        }
        String baseDir = ".";
        if (script.getParentFile() != null) {
            baseDir = script.getParentFile().getAbsolutePath();
        }
        if (filename.endsWith(".mtbl")) {
            ScriptEngine engine = new ScriptEngine(baseDir, params);
            engine.run(script);
        } else if (filename.endsWith(".mtbl.md")) {
            MarkdownScriptEngine engine = new MarkdownScriptEngine(baseDir, params);
            String output = filename.replaceAll(".mtbl.md", ".html");
            engine.run(script, new File(output));
        } else {
            System.out.println("Please specify a mtbl or mtbl.md file.");
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) throws CompilationFailedException, IOException, ClassNotFoundException {
        App app = new App();
        int result = app.run(args);
        System.exit(result);
    }
}

