/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables;

import com.jakewharton.fliptables.FlipTable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import lukfor.tables.ColumnOperations;
import lukfor.tables.RowOperations;
import lukfor.tables.columns.AbstractColumn;
import lukfor.tables.columns.ColumnType;
import lukfor.tables.columns.ColumnTypeDetector;
import lukfor.tables.columns.types.StringColumn;
import lukfor.tables.rows.IRowAggregator;
import lukfor.tables.rows.IRowMapper;
import lukfor.tables.rows.IRowProcessor;
import lukfor.tables.rows.Row;
import lukfor.tables.rows.TableIndex;
import lukfor.tables.rows.mappers.BinRowMapper;
import lukfor.tables.rows.processors.RowCopyProcessor;
import lukfor.tables.rows.processors.RowGroupProcessor;
import lukfor.tables.utils.GroupByBuilder;

public class Table {
    private String name;
    protected List<AbstractColumn> storage = new Vector<AbstractColumn>();
    private RowOperations rows;
    private ColumnOperations columns;

    public Table(String name) {
        this.name = name;
        this.rows = new RowOperations(this);
        this.columns = new ColumnOperations(this);
    }

    public Object get(int index, String column) throws IOException {
        this.assertsColumnExists(column);
        return this.columns.get(column).get(index);
    }

    public Object get(int index, int column) throws IOException {
        this.assertsColumnExists(column);
        return this.columns.get(column).get(index);
    }

    public AbstractColumn getColumn(String name) {
        return this.columns.get(name);
    }

    public AbstractColumn getColumn(int index) {
        return this.columns.get(index);
    }

    public void forEachRow(IRowProcessor processor) throws IOException {
        this.assertsNotEmpty();
        int i = 0;
        while (i < this.getRows().getSize()) {
            Row row = this.rows.get(i);
            processor.process(row);
            ++i;
        }
    }

    public ColumnOperations getColumns() {
        return this.columns;
    }

    public RowOperations getRows() {
        return this.rows;
    }

    public GroupByBuilder groupBy(final String column) throws IOException {
        IRowMapper mapper = new IRowMapper(){

            @Override
            public Object getKey(Row row) throws IOException {
                return row.getObject(column);
            }
        };
        return new GroupByBuilder(this, mapper, column);
    }

    public Table groupBy(final String column, IRowAggregator aggregator) throws IOException {
        return this.groupBy(new IRowMapper(){

            @Override
            public Object getKey(Row row) throws IOException {
                return row.getObject(column);
            }
        }, aggregator);
    }

    public Table binBy(String column, double binSize, IRowAggregator aggregator) throws IOException {
        return this.groupBy(new BinRowMapper("MAF", binSize), aggregator);
    }

    public Table groupBy(IRowMapper mapper, IRowAggregator aggregator) throws IOException {
        RowGroupProcessor processor = new RowGroupProcessor(mapper);
        this.forEachRow(processor);
        Table result = null;
        Map<Object, List<Integer>> groups = processor.getGroups();
        for (Object key : groups.keySet()) {
            List<Integer> indices = groups.get(key);
            Table groupedTable = this.cloneStructure(String.valueOf(this.name) + ":" + key);
            for (Integer index : indices) {
                groupedTable.getRows().append(this.getRows().get(index));
            }
            Table reducedTable = aggregator.aggregate(key, groupedTable);
            if (result == null) {
                result = reducedTable;
                continue;
            }
            result.append(reducedTable);
        }
        return result;
    }

    public List<Table> splitBy(IRowMapper mapper) throws IOException {
        RowGroupProcessor processor = new RowGroupProcessor(mapper);
        this.forEachRow(processor);
        Vector<Table> result = new Vector<Table>();
        Map<Object, List<Integer>> groups = processor.getGroups();
        for (Object key : groups.keySet()) {
            List<Integer> indices = groups.get(key);
            Table groupedTable = this.cloneStructure(String.valueOf(this.name) + ":" + key);
            for (Integer index : indices) {
                groupedTable.getRows().append(this.getRows().get(index));
            }
            result.add(groupedTable);
        }
        return result;
    }

    public void append(Table table) throws IOException {
        table.forEachRow(new RowCopyProcessor(this));
    }

    public int getMissings() {
        int missings = 0;
        for (AbstractColumn column : this.storage) {
            missings += column.getMissings();
        }
        return missings;
    }

    public void fillMissings(Object value) {
        for (AbstractColumn column : this.storage) {
            column.fillMissings(value);
        }
    }

    public int getUniqueValues() {
        int uniques = 0;
        for (AbstractColumn column : this.storage) {
            uniques += column.getUniqueValues();
        }
        return uniques;
    }

    public void replaceValue(Object oldValue, Object newValue) throws IOException {
        this.replaceValue(new Object[]{oldValue}, new Object[]{newValue});
    }

    public void replaceValue(Object[] oldValues, Object[] newValues) throws IOException {
        for (AbstractColumn column : this.storage) {
            column.replaceValue(oldValues, newValues);
        }
    }

    public void merge(Table table2, String column) throws IOException {
        this.merge(table2, column, column);
    }

    public void merge(final Table table2, final String columnTable1, final String columnTable2) throws IOException {
        System.out.println("Merging table " + this.getName() + " with table " + table2.getName() + " on " + columnTable1 + "=" + columnTable2 + "...");
        final Vector<String> columnsTable2 = new Vector<String>();
        int i = 0;
        while (i < table2.getColumns().getSize()) {
            AbstractColumn columTable2 = table2.getColumns().get(i);
            if (!columTable2.getName().equals(columnTable2)) {
                AbstractColumn newColumn = columTable2.cloneStructure();
                this.columns.append(newColumn);
                columnsTable2.add(columTable2.getName());
            }
            ++i;
        }
        this.forEachRow(new IRowProcessor(){

            @Override
            public void process(Row row) throws IOException {
                Object value = row.getObject(columnTable1);
                List<Row> rowsTable2 = table2.getRows().getAll(columnTable2, value);
                if (rowsTable2.size() == 1) {
                    for (Row rowTable2 : rowsTable2) {
                        for (String columnTable22 : columnsTable2) {
                            Object valueTable2 = rowTable2.getObject(columnTable22);
                            Table.this.getColumn(columnTable22).set(row.getIndex(), valueTable2);
                        }
                    }
                } else if (rowsTable2.size() == 0) {
                    for (String columnTable23 : columnsTable2) {
                        Table.this.getColumn(columnTable23).set(row.getIndex(), null);
                    }
                } else {
                    throw new IOException("simple merge not possible. No one to one mapping found.");
                }
            }
        });
        System.out.println("Merged tables. New size [" + this.getRows().getSize() + " x " + this.getColumns().getSize() + "]");
    }

    public Table cloneStructure(String name) throws IOException {
        Table table = new Table(String.valueOf(this.getName()) + ":" + name);
        for (AbstractColumn column : this.storage) {
            table.getColumns().append(column.cloneStructure());
        }
        return table;
    }

    public Table clone() {
        Table table = null;
        try {
            table = this.cloneStructure("cloned");
            for (AbstractColumn column : this.storage) {
                table.getColumn(column.getName()).copyDataFrom(column);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return table;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TableIndex createIndex(String column) throws IOException {
        this.assertsColumnExists(column);
        TableIndex index = new TableIndex(this);
        index.build(this.getColumn(column));
        return index;
    }

    public String toString() {
        try {
            return this.getAsString(0, 25);
        }
        catch (Exception e) {
            return "ERROR";
        }
    }

    protected void assertsColumnExists(String column) throws IOException {
        if (this.columns.get(column) == null) {
            throw new IOException("Column '" + column + "' not found.");
        }
    }

    protected void assertsColumnExists(int column) throws IOException {
        if (column >= this.getColumns().getSize()) {
            throw new IOException("Column '" + column + "' not found.");
        }
    }

    protected void assertsNotEmpty() throws IOException {
        if (this.storage.size() == 0) {
            throw new IOException("Table is empty.");
        }
    }

    public void printFirst(int n) throws IOException {
        n = Math.min(n, this.getRows().getSize());
        this.printBetween(0, n - 1);
    }

    public void printLast(int n) throws IOException {
        int height = this.getRows().getSize() - 1;
        int start = Math.max(height - n, 0);
        this.printBetween(start, height);
    }

    public void printBetween(int start, int end) throws IOException {
        System.out.println(this.getAsString(start, end));
    }

    public String getAsString(int start, int end) throws IOException {
        int height = this.getRows().getSize() - 1;
        start = Math.max(start, 0);
        end = Math.min(end, height);
        String[] columns = this.getColumns().getNames();
        String[] header = new String[columns.length + 1];
        header[0] = "";
        int i = 0;
        while (i < columns.length) {
            header[i + 1] = columns[i];
            ++i;
        }
        String[][] data = this.getRows().data(start, end);
        String result = "";
        result = String.valueOf(result) + "\n" + this.name + ":\n";
        result = String.valueOf(result) + FlipTable.of((String[])header, (String[][])data);
        result = String.valueOf(result) + "Showing " + (start + 1) + " to " + (end + 1) + " of " + this.getRows().getSize() + " entries, " + this.getColumns().getSize() + " total columns\n\n";
        return result;
    }

    public void print() throws IOException {
        this.printFirst(25);
    }

    public void printAll() throws IOException {
        this.printFirst(this.getRows().getSize());
    }

    public Table getSummary() throws IOException {
        Table table = new Table(String.valueOf(this.name) + ":summary");
        table.getColumns().append(new StringColumn("column"));
        table.getColumns().append(new StringColumn("type"));
        table.getColumns().append(new StringColumn("min"));
        table.getColumns().append(new StringColumn("mean"));
        table.getColumns().append(new StringColumn("max"));
        table.getColumns().append(new StringColumn("missings"));
        table.getColumns().append(new StringColumn("n"));
        for (AbstractColumn column : this.storage) {
            Row row = new Row();
            row.setString("column", column.getName());
            row.setString("type", (Object)column.getType());
            row.setString("min", column.getMin());
            row.setString("mean", column.getMean());
            row.setString("max", column.getMax());
            row.setString("missings", column.getMissings());
            row.setString("n", column.getSize() - column.getMissings());
            table.getRows().append(row);
        }
        return table;
    }

    public void printSummary() throws IOException {
        System.out.println(String.valueOf(this.name) + " [" + this.getRows().getSize() + " x " + this.getColumns().getSize() + "]");
        Table table = this.getSummary();
        table.printAll();
    }

    public void detectTypes() throws IOException {
        int i = 0;
        while (i < this.getColumns().getSize()) {
            AbstractColumn column = this.getColumns().get(i);
            ColumnType type = ColumnTypeDetector.guessType(column);
            if (type != column.getType()) {
                System.out.println("Update type of " + column.getName() + " to " + (Object)((Object)type) + "...");
                this.getColumns().setType(column, type);
            }
            ++i;
        }
    }
}

