/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables.columns;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import lukfor.tables.columns.ColumnType;
import lukfor.tables.columns.IApplyFunction;

public abstract class AbstractColumn {
    protected List<Object> storage;
    private String name;

    public AbstractColumn(int initSize) {
        this.storage = new Vector<Object>(initSize);
    }

    public void copyDataFrom(AbstractColumn column) {
        int i = 0;
        while (i < column.getSize()) {
            Object object = column.get(i);
            if (object != null) {
                this.storage.add(this.valueToObject(object.toString()));
            } else {
                this.storage.add(null);
            }
            ++i;
        }
    }

    public void replaceDataFrom(AbstractColumn column) {
        int i = 0;
        while (i < column.getSize()) {
            Object object = column.get(i);
            if (object != null) {
                this.storage.set(i, this.valueToObject(object.toString()));
            } else {
                this.storage.set(i, null);
            }
            ++i;
        }
    }

    public List<Number> getValues() {
        Vector<Number> numbers = new Vector<Number>();
        int i = 0;
        while (i < this.getSize()) {
            Object object = this.get(i);
            numbers.add((Number)object);
            ++i;
        }
        return numbers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract ColumnType getType();

    public void set(int index, Object data) {
        this.storage.set(index, data);
    }

    public abstract boolean accepts(Object var1);

    public abstract Object valueToObject(String var1);

    public abstract String objectToValue(Object var1);

    public void add(Object data) {
        if (this.isMissingValue(data)) {
            this.storage.add(null);
        } else {
            this.storage.add(data);
        }
    }

    public Object get(int index) {
        if (index < this.storage.size()) {
            return this.storage.get(index);
        }
        return null;
    }

    public int getSize() {
        return this.storage.size();
    }

    public void drop(List<Boolean> bitmask) {
        Vector<Object> newStorage = new Vector<Object>();
        int i = 0;
        while (i < this.storage.size()) {
            if (!bitmask.get(i).booleanValue()) {
                newStorage.add(this.storage.get(i));
            }
            ++i;
        }
        this.storage.clear();
        this.storage.addAll(newStorage);
        newStorage.clear();
    }

    public void select(List<Boolean> bitmask) {
        Vector<Object> newStorage = new Vector<Object>();
        int i = 0;
        while (i < this.storage.size()) {
            if (bitmask.get(i).booleanValue()) {
                newStorage.add(this.storage.get(i));
            }
            ++i;
        }
        this.storage.clear();
        this.storage.addAll(newStorage);
        newStorage.clear();
    }

    public void sort(List<Integer> indices) {
        Vector<Object> newStorage = new Vector<Object>();
        int i = 0;
        while (i < indices.size()) {
            int index = indices.get(i);
            Object value = this.storage.get(index);
            newStorage.add(value);
            ++i;
        }
        this.storage.clear();
        this.storage.addAll(newStorage);
        newStorage.clear();
    }

    public abstract int compare(Object var1, Object var2);

    public String toString() {
        return String.valueOf(this.name) + " [" + (Object)((Object)this.getType()) + "]";
    }

    public void fillMissings(Object value) {
        int i = 0;
        while (i < this.storage.size()) {
            if (this.storage.get(i) == null) {
                this.storage.set(i, value);
            }
            ++i;
        }
    }

    public void apply(IApplyFunction function) throws IOException {
        int i = 0;
        while (i < this.storage.size()) {
            Object value = this.storage.get(i);
            Object newValue = function.apply(value);
            this.storage.set(i, newValue);
            ++i;
        }
    }

    public void replaceValue(Object oldValue, Object newValue) throws IOException {
        this.replaceValue(new Object[]{oldValue}, new Object[]{newValue});
    }

    public void replaceValue(Object[] oldValues, Object[] newValues) throws IOException {
        if (oldValues.length != newValues.length) {
            throw new IOException("Arrays 'oldValues' and 'newValues' have different length.");
        }
        int i = 0;
        while (i < this.storage.size()) {
            Object value = this.storage.get(i);
            int j = 0;
            while (j < oldValues.length) {
                Object oldValue = oldValues[j];
                Object newValue = newValues[j];
                if (value == null && oldValue == null) {
                    this.storage.set(i, newValue);
                } else if (value != null && value.equals(oldValue)) {
                    this.storage.set(i, newValue);
                }
                ++j;
            }
            ++i;
        }
    }

    public int getMissings() {
        int missings = 0;
        int i = 0;
        while (i < this.storage.size()) {
            if (this.storage.get(i) == null) {
                ++missings;
            }
            ++i;
        }
        return missings;
    }

    public int getUniqueValues() {
        HashSet<Integer> uniques = new HashSet<Integer>();
        int i = 0;
        while (i < this.storage.size()) {
            Object value = this.storage.get(i);
            if (value != null) {
                int hash = value.hashCode();
                uniques.add(hash);
            }
            ++i;
        }
        return uniques.size();
    }

    public Object getSum() {
        return null;
    }

    public Object getMean() {
        return null;
    }

    public Object getMin() {
        return null;
    }

    public Object getMax() {
        return null;
    }

    public String getSummary() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            PrintStream ps = new PrintStream((OutputStream)baos, true, "UTF-8");
            this.printSummary(ps);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    public void printSummary() {
        this.printSummary(System.out);
    }

    public void printSummary(PrintStream out) {
        Object max;
        Object mean;
        out.println(String.valueOf(this.name) + " [" + (Object)((Object)this.getType()) + "] :");
        int missings = this.getMissings();
        out.println("  N: " + (this.getSize() - missings));
        out.println("  Missings: " + missings);
        Object min = this.getMin();
        if (min != null) {
            out.println("  Min.: " + min);
        }
        if ((mean = this.getMean()) != null) {
            out.println("  Mean.: " + mean);
        }
        if ((max = this.getMax()) != null) {
            out.println("  Max.: " + max);
        }
    }

    public abstract boolean isMissingValue(Object var1);

    public abstract AbstractColumn cloneStructure();
}

