/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables.io;

import genepi.io.FileUtil;
import genepi.io.table.reader.CsvTableReader;
import genepi.io.table.reader.ExcelTableReader;
import genepi.io.table.reader.ITableReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import lukfor.tables.Table;
import lukfor.tables.columns.AbstractColumn;
import lukfor.tables.columns.types.StringColumn;
import lukfor.tables.io.options.CsvTableOptions;
import lukfor.tables.io.options.ExcelTableOptions;

public class TableBuilder {
    public static CsvTableOptions fromCsvFile(String filename) {
        return new CsvTableOptions(filename);
    }

    public static Table fromCsvFile(CsvTableOptions options) throws IOException {
        System.out.println("Reading Csv file " + options.getFilename() + "...");
        FileInputStream inputStream = new FileInputStream(options.getFilename());
        InputStream in2 = FileUtil.decompressStream((InputStream)inputStream);
        CsvTableReader reader = new CsvTableReader(new DataInputStream(in2), options.getSeparator());
        String name = FileUtil.getFilename((String)options.getFilename());
        return TableBuilder.fromTableReader(name, (ITableReader)reader, options.isColumnTypeDetection());
    }

    public static ExcelTableOptions fromXlsFile(String filename) throws IOException {
        return new ExcelTableOptions(filename);
    }

    public static Table fromXlsFile(ExcelTableOptions options) throws IOException {
        System.out.println("Reading Excel file " + options.getFilename() + "...");
        ExcelTableReader reader = new ExcelTableReader(options.getFilename());
        String name = FileUtil.getFilename((String)options.getFilename());
        return TableBuilder.fromTableReader(name, (ITableReader)reader, options.isColumnTypeDetection());
    }

    public static Table fromFile(String filename, char separator) throws IOException {
        ExcelTableReader reader = null;
        if (filename.endsWith(".xls")) {
            System.out.println("Reading Excel file " + filename + "...");
            reader = new ExcelTableReader(filename);
        } else {
            System.out.println("Reading Csv file " + filename + "...");
            reader = new CsvTableReader(filename, separator);
        }
        String name = FileUtil.getFilename((String)filename);
        return TableBuilder.fromTableReader(name, (ITableReader)reader, true);
    }

    public static Table fromTableReader(String name, ITableReader reader, boolean columnTypeDetection) throws IOException {
        Table table = new Table(name);
        String[] stringArray = reader.getColumns();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            table.getColumns().append(new StringColumn(column));
            ++n2;
        }
        while (reader.next()) {
            int i = 0;
            while (i < table.getColumns().getSize()) {
                AbstractColumn column = table.getColumns().get(i);
                String value = reader.getString(column.getName());
                Object object = column.valueToObject(value);
                column.add(object);
                ++i;
            }
        }
        reader.close();
        if (columnTypeDetection) {
            table.detectTypes();
        }
        System.out.println("Loaded table " + table.getName() + " [" + table.getRows().getSize() + " x " + table.getColumns().getSize() + "] into memory.");
        return table;
    }

    public static Table fromDatabase(Connection connection, String sql) throws SQLException, IOException {
        Object column;
        Table table = new Table(sql);
        Statement statement = connection.createStatement();
        ResultSet result = statement.executeQuery(sql);
        ResultSetMetaData meta = result.getMetaData();
        int i = 0;
        while (i < meta.getColumnCount()) {
            column = meta.getColumnName(i + 1);
            table.getColumns().append(new StringColumn((String)column));
            ++i;
        }
        while (result.next()) {
            i = 0;
            while (i < meta.getColumnCount()) {
                column = table.getColumns().get(i);
                String value = result.getString(i + 1);
                Object object = ((AbstractColumn)column).valueToObject(value);
                ((AbstractColumn)column).add(object);
                ++i;
            }
        }
        System.out.println("Loaded table " + table.getName() + " [" + table.getRows().getSize() + " x " + table.getColumns().getSize() + "] into memory.");
        return table;
    }
}

