/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables.rows;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lukfor.tables.columns.types.DoubleColumn;

public class Row {
    private Map<String, Object> values = new HashMap<String, Object>();
    private int index;

    public Row() {
    }

    public Row(int index) {
        this.index = index;
    }

    public Object getObject(String column) throws IOException {
        if (this.values.containsKey(column)) {
            return this.values.get(column);
        }
        throw new IOException("Column '" + column + "' not found.");
    }

    public String getString(String column) throws IOException {
        return (String)this.getObject(column);
    }

    public int getInteger(String column) throws IOException {
        return (Integer)this.getObject(column);
    }

    public double getDouble(String column) throws IOException {
        return (Double)this.getObject(column);
    }

    public void set(String column, Object value) {
        this.values.put(column, value);
    }

    public void setString(String column, Object value) {
        if (value != null) {
            if (value instanceof Double) {
                value = DoubleColumn.FORMAT.format(value);
            }
            this.values.put(column, value.toString());
        } else {
            this.values.put(column, null);
        }
    }

    public boolean hasMissings() {
        for (String key : this.values.keySet()) {
            if (this.values.get(key) != null) continue;
            return true;
        }
        return false;
    }

    public int getHashCode() {
        return this.values.hashCode();
    }

    public int getIndex() {
        return this.index;
    }
}

