/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables.rows;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lukfor.tables.Table;
import lukfor.tables.columns.AbstractColumn;
import lukfor.tables.rows.Row;

public class TableIndex {
    private Table table;
    private Map<Object, Integer> index;

    public TableIndex(Table table) throws IOException {
        this.table = table;
    }

    public void build(AbstractColumn column) throws IOException {
        this.index = new HashMap<Object, Integer>();
        int i = 0;
        while (i < column.getSize()) {
            Object value = column.get(i);
            if (this.index.containsKey(value)) {
                throw new IOException("Index creation not possible. Values in column are not unique. For example '" + value + "' found twice.");
            }
            this.index.put(value, i);
            ++i;
        }
    }

    public Row getRow(Object value) {
        Integer position = this.index.get(value);
        if (position != null) {
            return this.table.getRows().get(position);
        }
        return null;
    }
}

