/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables.script;

import genepi.io.FileUtil;
import groovy.lang.Writable;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import lukfor.tables.script.ScriptEngine;
import org.codehaus.groovy.control.CompilationFailedException;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Node;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public class MarkdownScriptEngine {
    public static final String DEFAULT_TEMPLATE = "templates/github.html";
    private ScriptEngine engine;
    private ByteArrayOutputStream out;

    public MarkdownScriptEngine(String baseDir, Map<String, String> params) {
        this.engine = new ScriptEngine(baseDir, params);
    }

    public void run(File input, File output) throws CompilationFailedException, ClassNotFoundException, IOException {
        System.out.println("Running script file " + input.getAbsolutePath() + "...");
        Parser parser = Parser.builder().build();
        Node document = parser.parse(FileUtil.readFileAsString((String)input.getAbsolutePath()));
        PrintStream oldOut = System.out;
        this.out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.out));
        document.accept((Visitor)new CodeBlockVisitor());
        System.setOut(oldOut);
        HtmlRenderer renderer = HtmlRenderer.builder().build();
        String content = renderer.render(document);
        SimpleTemplateEngine templateEngine = new SimpleTemplateEngine();
        ClassLoader classLoader = MarkdownScriptEngine.class.getClassLoader();
        URL resource = classLoader.getResource(DEFAULT_TEMPLATE);
        Template template = templateEngine.createTemplate(resource);
        HashMap<String, String> bindingTemplate = new HashMap<String, String>();
        bindingTemplate.put("title", "lukfor-tables");
        bindingTemplate.put("author", System.getProperty("user.name"));
        bindingTemplate.put("content", content);
        bindingTemplate.put("date", new Date().toString());
        bindingTemplate.put("username", System.getProperty("user.name"));
        Writable writable = template.make(bindingTemplate);
        FileUtil.writeStringBufferToFile((String)output.getAbsolutePath(), (StringBuffer)new StringBuffer(writable.toString()));
        System.out.println("Output written to file " + output.getAbsolutePath());
    }

    class CodeBlockVisitor
    extends AbstractVisitor {
        CodeBlockVisitor() {
        }

        public void visit(FencedCodeBlock fencedCodeBlock) {
            String scriptText = fencedCodeBlock.getLiteral();
            try {
                MarkdownScriptEngine.this.out.reset();
                MarkdownScriptEngine.this.engine.run(scriptText);
            }
            catch (Exception e) {
                e.printStackTrace(new PrintStream(MarkdownScriptEngine.this.out));
            }
            fencedCodeBlock.setLiteral("> " + scriptText.replaceAll("\n", "\n> ") + "\n\n" + MarkdownScriptEngine.this.out.toString());
            this.visitChildren((Node)fencedCodeBlock);
        }
    }
}

