/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables.script;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import lukfor.tables.script.ScriptContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class ScriptEngine {
    private GroovyShell shell;

    public ScriptEngine(String baseDir, Map<String, String> params) {
        CompilerConfiguration compilerConfiguration = this.createCompilerConfiguration();
        this.initScriptContext(baseDir, params);
        Binding binding = new Binding();
        this.shell = new GroovyShell(compilerConfiguration);
    }

    public void run(File file) throws CompilationFailedException, IOException {
        Script script = this.shell.parse(file);
        script.run();
    }

    public void run(String scriptText) throws CompilationFailedException, IOException {
        Script script = this.shell.parse(scriptText);
        script.run();
    }

    private CompilerConfiguration createCompilerConfiguration() {
        ImportCustomizer customizer = new ImportCustomizer();
        customizer.addStarImports(new String[]{"lukfor.tables"});
        customizer.addStarImports(new String[]{"lukfor.tables.io"});
        customizer.addStarImports(new String[]{"lukfor.tables.rows"});
        customizer.addStarImports(new String[]{"lukfor.tables.columns"});
        customizer.addStarImports(new String[]{"lukfor.tables.columns.types"});
        customizer.addStaticStars(new String[]{"lukfor.tables.io.TableBuilder"});
        customizer.addStaticStars(new String[]{"lukfor.tables.script.ScriptContext"});
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
        return compilerConfiguration;
    }

    private void initScriptContext(String baseDir, Map<String, String> params) {
        for (String param : params.keySet()) {
            ScriptContext.params.put(param, params.get(param));
        }
        ScriptContext.baseDir = baseDir;
    }
}

