/*
 * Decompiled with CFR 0.152.
 */
package lukfor.tables.utils;

import java.io.IOException;
import lukfor.tables.Table;
import lukfor.tables.rows.IRowAggregator;
import lukfor.tables.rows.IRowMapper;
import lukfor.tables.rows.aggregators.CountRowAggregator;
import lukfor.tables.rows.aggregators.MaxRowAggregator;
import lukfor.tables.rows.aggregators.MeanRowAggregator;
import lukfor.tables.rows.aggregators.MinRowAggregator;
import lukfor.tables.rows.aggregators.SumRowAggregator;

public class GroupByBuilder {
    private Table table;
    private IRowMapper mapper;
    private String keyColumn;

    public GroupByBuilder(Table table, IRowMapper mapper, String keyColumn) {
        this.table = table;
        this.mapper = mapper;
        this.keyColumn = keyColumn;
    }

    public Table count() throws IOException {
        return this.table.groupBy(this.mapper, (IRowAggregator)new CountRowAggregator(this.keyColumn));
    }

    public Table sum(String column) throws IOException {
        return this.table.groupBy(this.mapper, (IRowAggregator)new SumRowAggregator(this.keyColumn, column));
    }

    public Table mean(String column) throws IOException {
        return this.table.groupBy(this.mapper, (IRowAggregator)new MeanRowAggregator(this.keyColumn, column));
    }

    public Table min(String column) throws IOException {
        return this.table.groupBy(this.mapper, (IRowAggregator)new MinRowAggregator(this.keyColumn, column));
    }

    public Table max(String column) throws IOException {
        return this.table.groupBy(this.mapper, (IRowAggregator)new MaxRowAggregator(this.keyColumn, column));
    }

    public Table aggregate(IRowAggregator aggregator) throws IOException {
        return this.table.groupBy(this.mapper, aggregator);
    }
}

