/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.commands;

import genepi.io.FileUtil;
import genepi.riskscore.App;
import genepi.riskscore.io.Chunk;
import genepi.riskscore.io.MetaFile;
import genepi.riskscore.io.OutputFile;
import genepi.riskscore.io.PGSCatalogIDFile;
import genepi.riskscore.io.ReportFile;
import genepi.riskscore.io.formats.RiskScoreFormatFactory;
import genepi.riskscore.tasks.ApplyScoreTask;
import genepi.riskscore.tasks.CreateHtmlReportTask;
import genepi.riskscore.tasks.MergeEffectsTask;
import genepi.riskscore.tasks.MergeReportTask;
import genepi.riskscore.tasks.MergeScoreTask;
import htsjdk.samtools.util.StopWatch;
import java.io.File;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import lukfor.progress.TaskService;
import lukfor.progress.renderer.IProgressIndicator;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.Task;
import picocli.CommandLine;

@CommandLine.Command(name="apply", version={"0.9.16"})
public class ApplyScoreCommand
implements Callable<Integer> {
    @CommandLine.Parameters(description={"VCF files"})
    List<String> vcfs;
    @CommandLine.Option(names={"--ref"}, description={"Reference weights"}, required=true)
    String ref;
    @CommandLine.Option(names={"--out"}, description={"Output filename"}, required=true)
    String out;
    @CommandLine.Option(names={"--minR2"}, description={"Minimal imputation quality"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    float minR2 = 0.0f;
    @CommandLine.Option(names={"--genotypes"}, description={"Genotype field (DS or GT)"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    String genotypeFormat = "DS";
    @CommandLine.Option(names={"--threads"}, description={"Number of threads"}, required=false)
    int threads = 1;
    @CommandLine.Option(names={"--writeVariants"}, description={"Write csv file with all used variants"}, required=false)
    String outputVariantFilename = null;
    @CommandLine.Option(names={"--includeVariants"}, description={"Include only variants from this file"}, required=false)
    String includeVariantFilename = null;
    @CommandLine.Option(names={"--samples"}, description={"Include only samples from this file"}, required=false)
    String includeSamplesFilename = null;
    @CommandLine.Option(names={"--report-json", "--info"}, description={"Write statistics to json file"}, required=false)
    String reportJson = null;
    @CommandLine.Option(names={"--report-html"}, description={"Write statistics to html file"}, required=false)
    String reportHtml = null;
    @CommandLine.Option(names={"--meta"}, description={"JSON file with meta data about scores"}, required=false)
    String meta = null;
    @CommandLine.Option(names={"--writeEffects"}, description={"Write file with effects per snp and sample"}, required=false)
    String outputEffectsFilename = null;
    @CommandLine.Option(names={"--dbsnp"}, description={"dbSNP Index file to support rsIDs"}, required=false)
    String dbsnp = null;
    @CommandLine.Option(names={"--help"}, usageHelp=true)
    boolean showHelp;
    @CommandLine.Option(names={"--no-ansi"}, description={"Disable ANSI output"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean noAnsi = false;
    @CommandLine.Option(names={"--version"}, versionHelp=true)
    boolean showVersion;
    @CommandLine.ArgGroup(exclusive=false, multiplicity="0..1")
    Chunk chunk;

    @Override
    public Integer call() throws Exception {
        if (this.noAnsi) {
            TaskService.setAnimated((boolean)false);
            TaskService.setAnsiColors((boolean)false);
        }
        if (this.vcfs == null || this.vcfs.isEmpty()) {
            System.out.println();
            System.out.println("Please provide at least one VCF file.");
            System.out.println();
            return 1;
        }
        System.out.println();
        System.out.println("Input:");
        System.out.println("  ref: " + this.ref);
        System.out.println("  out: " + this.out);
        System.out.println("  genotypes: " + this.genotypeFormat);
        System.out.println("  minR2: " + this.minR2);
        if (this.chunk != null) {
            System.out.println("  Chunk: " + this.chunk.getStart() + " - " + this.chunk.getEnd());
        }
        System.out.println("  vcfs (" + this.vcfs.size() + "):");
        for (String vcf : this.vcfs) {
            System.out.println("   - " + vcf);
        }
        System.out.println();
        StopWatch watch = new StopWatch();
        watch.start();
        String outParent = new File(this.out).getParent();
        String tempFolder = FileUtil.path((String[])new String[]{outParent, "temp"});
        File tempFolderFile = new File(tempFolder);
        tempFolderFile.mkdirs();
        Vector<ApplyScoreTask> tasks = new Vector<ApplyScoreTask>();
        for (String vcf : this.vcfs) {
            ApplyScoreTask task = new ApplyScoreTask();
            String[] refs = this.parseRef(this.ref);
            task.setRiskScoreFilenames(refs);
            String[] stringArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                String autoFormat = String.valueOf(file) + ".format";
                if (new File(autoFormat).exists()) {
                    task.setRiskScoreFormat(file, RiskScoreFormatFactory.RiskScoreFormat.MAPPING_FILE);
                }
                ++n2;
            }
            if (this.chunk != null) {
                task.setChunk(this.chunk);
            }
            String taskPrefix = FileUtil.path((String[])new String[]{tempFolder, "task_" + tasks.size()});
            if (this.dbsnp != null) {
                task.setDbSnp(this.dbsnp);
            }
            task.setVcfFilename(vcf);
            task.setMinR2(this.minR2);
            task.setGenotypeFormat(this.genotypeFormat);
            task.setOutputVariantFilename(this.outputVariantFilename);
            if (this.outputEffectsFilename != null) {
                task.setOutputEffectsFilename(String.valueOf(taskPrefix) + ".effects.txt");
            }
            task.setIncludeVariantFilename(this.includeVariantFilename);
            task.setIncludeSamplesFilename(this.includeSamplesFilename);
            task.setOutput(String.valueOf(taskPrefix) + ".scores.txt");
            tasks.add(task);
        }
        TaskService.setThreads((int)this.threads);
        List results = TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_LONG_TASK}).run(tasks);
        if (this.isFailed(results)) {
            this.cleanUp();
            return 1;
        }
        System.out.println();
        MergeScoreTask mergeScore = new MergeScoreTask();
        mergeScore.setInputs(tasks);
        mergeScore.setOutput(this.out);
        if (this.isFailed(TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_SHORT_TASK}).run(new ITaskRunnable[]{mergeScore}))) {
            this.cleanUp();
            return 1;
        }
        if (this.outputEffectsFilename != null) {
            MergeEffectsTask mergeEffectsTask = new MergeEffectsTask();
            mergeEffectsTask.setInputs(tasks);
            mergeEffectsTask.setOutput(this.outputEffectsFilename);
            if (this.isFailed(TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_SHORT_TASK}).run(new ITaskRunnable[]{mergeEffectsTask}))) {
                this.cleanUp();
                return 1;
            }
        }
        MergeReportTask mergeReport = new MergeReportTask();
        mergeReport.setInputs(tasks);
        mergeReport.setOutput(this.reportJson);
        if (this.isFailed(TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_SHORT_TASK}).run(new ITaskRunnable[]{mergeReport}))) {
            this.cleanUp();
            return 1;
        }
        ReportFile report = mergeReport.getResult();
        if (this.reportHtml != null) {
            if (this.meta != null) {
                MetaFile metaFile = MetaFile.load(this.meta);
                report.mergeWithMeta(metaFile);
            }
            OutputFile data = new OutputFile(this.out);
            CreateHtmlReportTask htmlReportTask = new CreateHtmlReportTask();
            htmlReportTask.setReport(report);
            htmlReportTask.setData(data);
            htmlReportTask.setOutput(this.reportHtml);
            if (this.isFailed(TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_SHORT_TASK}).run(new ITaskRunnable[]{htmlReportTask}))) {
                this.cleanUp();
                return 1;
            }
        }
        System.out.println();
        System.out.println("Execution Time: " + this.formatTime(watch.getElapsedTimeSecs()));
        System.out.println();
        watch.stop();
        this.cleanUp();
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private String[] parseRef(String ref) {
        try {
            file = new PGSCatalogIDFile(ref);
            return file.getIds();
        }
        catch (Exception e) {
            refs = ref.split(",");
            i = 0;
            ** while (i < refs.length)
        }
lbl-1000:
        // 1 sources

        {
            refs[i] = refs[i].trim();
            ++i;
            continue;
        }
lbl11:
        // 1 sources

        return refs;
    }

    public String formatTime(long timeInSeconds) {
        return String.format("%d min, %d sec", timeInSeconds / 60L, timeInSeconds % 60L);
    }

    private boolean isFailed(List<Task> tasks) {
        for (Task result : tasks) {
            if (result.getStatus().isSuccess()) continue;
            return true;
        }
        return false;
    }

    public void cleanUp() {
        String outParent = new File(this.out).getParent();
        String tempFolder = FileUtil.path((String[])new String[]{outParent, "temp"});
        File tempFolderFile = new File(tempFolder);
        if (tempFolderFile.exists()) {
            FileUtil.deleteDirectory((File)tempFolderFile);
        }
    }
}

