/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.commands;

import genepi.riskscore.App;
import genepi.riskscore.io.MetaFile;
import genepi.riskscore.io.OutputFile;
import genepi.riskscore.io.ReportFile;
import genepi.riskscore.tasks.CreateHtmlReportTask;
import java.util.List;
import java.util.concurrent.Callable;
import lukfor.progress.TaskService;
import lukfor.progress.renderer.IProgressIndicator;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.Task;
import picocli.CommandLine;

@CommandLine.Command(name="report", version={"0.9.16"})
public class CreateHtmlReportCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--data"}, description={"JSON file with meta data about scores"}, required=true)
    String data = null;
    @CommandLine.Option(names={"--info"}, description={"JSON file with meta data about scores"}, required=true)
    String info = null;
    @CommandLine.Option(names={"--meta"}, description={"JSON file with meta data about scores"}, required=false)
    String meta = null;
    @CommandLine.Option(names={"--out"}, description={"Output filename"}, required=true)
    String out;

    @Override
    public Integer call() throws Exception {
        ReportFile infoFile = ReportFile.loadFromFile(this.info);
        if (this.meta != null) {
            MetaFile metaFile = MetaFile.load(this.meta);
            infoFile.mergeWithMeta(metaFile);
        }
        OutputFile outputFile = new OutputFile(this.data);
        CreateHtmlReportTask htmlReportTask = new CreateHtmlReportTask();
        htmlReportTask.setReport(infoFile);
        htmlReportTask.setData(outputFile);
        htmlReportTask.setOutput(this.out);
        if (this.isFailed(TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_SHORT_TASK}).run(new ITaskRunnable[]{htmlReportTask}))) {
            return 1;
        }
        return 0;
    }

    private boolean isFailed(List<Task> tasks) {
        for (Task result : tasks) {
            if (result.getStatus().isSuccess()) continue;
            return true;
        }
        return false;
    }
}

