/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.commands;

import genepi.io.FileUtil;
import genepi.io.text.GzipLineWriter;
import genepi.io.text.LineReader;
import genepi.riskscore.io.PGSCatalog;
import genepi.riskscore.io.RiskScoreFile;
import genepi.riskscore.io.formats.RiskScoreFormatFactory;
import genepi.riskscore.io.formats.RiskScoreFormatImpl;
import genepi.riskscore.tasks.ResolveScoreTask;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import lukfor.progress.TaskService;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.Task;
import picocli.CommandLine;

@CommandLine.Command(name="resolve", version={"0.9.16"})
public class ResolveScoreCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--in"}, description={"input score file"}, required=true)
    private String input;
    @CommandLine.Option(names={"--out"}, description={"output score file"}, required=true)
    private String output;
    @CommandLine.Option(names={"--dbsnp"}, description={"dbsnp index file"}, required=true)
    private String dbsnp;

    @Override
    public Integer call() throws Exception {
        long start = System.currentTimeMillis();
        System.out.println("Input File: " + this.input);
        try {
            if (!new File(this.input).exists()) {
                if (PGSCatalog.isValidId(this.input)) {
                    String id = this.input;
                    this.input = PGSCatalog.getFilenameById(id);
                } else {
                    System.out.println("*** ERROR *** File '" + this.input + "' not found.");
                    return 1;
                }
            }
            RiskScoreFormatImpl format = RiskScoreFormatFactory.buildFormat(this.input, RiskScoreFormatFactory.RiskScoreFormat.PGS_CATALOG);
            System.out.println("Input File Format: " + format);
            System.out.println("--------------------------------------");
            if (format.hasRsIds()) {
                System.out.println("Resolve rsIDs using index file '" + this.dbsnp + "'...");
                ResolveScoreTask task = new ResolveScoreTask(this.input, String.valueOf(this.output) + ".raw", this.dbsnp);
                TaskService.setAnsiSupport((boolean)false);
                TaskService.setAnimated((boolean)false);
                List result = TaskService.run((ITaskRunnable[])new ITaskRunnable[]{task});
                if (!((Task)result.get(0)).getStatus().isSuccess()) {
                    ((Task)result.get(0)).getStatus().getThrowable().printStackTrace();
                    System.out.println("*** ERROR ***  " + ((Task)result.get(0)).getStatus().getThrowable());
                    return 1;
                }
                System.out.println("Number Variants Input: " + task.getTotal());
                System.out.println("Number Variants Resolved: " + task.getResolved());
                System.out.println("  Other Allele: ");
                System.out.println("    Reference Allele dbSNP: " + task.getOtherAlleleReference());
                System.out.println("    Alternate Allele dbSNP: " + task.getOtherAlleleAlternate());
                System.out.println("    From Source File: " + task.getOtherAlleleSource());
                System.out.println("Ignored Variants: ");
                System.out.println("  Not found in dbSNP: " + task.getIgnoredNotInDbSnp());
                System.out.println("  Multiple Alternate Alleles: " + task.getIgnoredMulAlternateAlleles());
                LineReader reader = new LineReader(String.valueOf(this.output) + ".raw");
                GzipLineWriter writer = new GzipLineWriter(this.output);
                while (reader.next()) {
                    writer.write(reader.get());
                }
                writer.close();
                reader.close();
                FileUtil.deleteFile((String)(String.valueOf(this.output) + ".raw"));
            } else {
                FileUtil.copy((String)this.input, (String)this.output);
            }
            System.out.println("--------------------------------------");
            RiskScoreFile score = null;
            int loaded = 0;
            int i = 1;
            while (i <= 22) {
                System.out.println("Validate chromosome " + i + "...");
                score = new RiskScoreFile(this.output, this.dbsnp);
                score.buildIndex(String.valueOf(i));
                loaded += score.getCacheSize();
                ++i;
            }
            long end = System.currentTimeMillis();
            System.out.println("--------------------------------------");
            System.out.println("Output File: " + this.output);
            System.out.println("Output File Format: " + score.getFormat());
            System.out.println("Number Variants Output: " + loaded + "/" + score.getTotalVariants());
            System.out.println("--------------------------------------");
            System.out.println("Execution Time: " + (end - start) / 1000L + " sec");
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("*** ERROR ***  " + e);
            new File(this.output).delete();
            return 1;
        }
    }
}

