/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.table.writer.CsvTableWriter;
import genepi.riskscore.model.RiskScore;
import genepi.riskscore.model.RiskScoreSummary;
import java.util.List;
import java.util.Vector;

public class OutputFileWriter {
    public static final String COLUMN_SAMPLE = "sample";
    public static final char SEPARATOR = ',';
    private List<String> samples;
    private List<Double>[] data;
    private List<String> scores;

    public OutputFileWriter() {
    }

    public OutputFileWriter(List<RiskScore> finalScores, RiskScoreSummary[] summaries) {
        this.scores = new Vector<String>();
        RiskScoreSummary[] riskScoreSummaryArray = summaries;
        int n = summaries.length;
        int n2 = 0;
        while (n2 < n) {
            RiskScoreSummary summary = riskScoreSummaryArray[n2];
            this.scores.add(summary.getName());
            ++n2;
        }
        this.samples = new Vector<String>();
        this.data = new Vector[this.scores.size()];
        int i = 0;
        while (i < this.scores.size()) {
            this.data[i] = new Vector<Double>();
            ++i;
        }
        for (RiskScore riskScore : finalScores) {
            this.samples.add(riskScore.getSample());
            int i2 = 0;
            while (i2 < this.scores.size()) {
                this.data[i2].add(riskScore.getScore(i2));
                ++i2;
            }
        }
    }

    public void save(String filename) {
        String[] columns = new String[this.scores.size() + 1];
        columns[0] = COLUMN_SAMPLE;
        int i = 0;
        while (i < this.scores.size()) {
            columns[i + 1] = this.scores.get(i);
            ++i;
        }
        CsvTableWriter writer = new CsvTableWriter(filename, ',');
        writer.setColumns(columns);
        int i2 = 0;
        while (i2 < this.samples.size()) {
            writer.setString(COLUMN_SAMPLE, this.samples.get(i2));
            int j = 0;
            while (j < this.scores.size()) {
                writer.setDouble(this.scores.get(j), this.data[j].get(i2).doubleValue());
                ++j;
            }
            writer.next();
            ++i2;
        }
        writer.close();
    }
}

