/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;

public class PGSCatalog {
    public static String USER_HOME = System.getProperty("user.home");
    public static boolean ENABLE_CACHE = true;
    public static String CACHE_DIR = FileUtil.path((String[])new String[]{USER_HOME, ".pgs-calc", "pgs-catalog"});
    public static String FILE_URL = "http://ftp.ebi.ac.uk/pub/databases/spot/pgs/scores/{0}/ScoringFiles/{0}.txt.gz";

    public static String getFilenameById(String id) throws IOException {
        String filename = FileUtil.path((String[])new String[]{CACHE_DIR, String.valueOf(id) + ".txt.gz"});
        if (new File(filename).exists()) {
            if (ENABLE_CACHE) {
                return filename;
            }
            new File(filename).delete();
        }
        FileUtil.createDirectory((String)CACHE_DIR);
        MessageFormat format = new MessageFormat(FILE_URL);
        String url = format.format(new Object[]{id});
        InputStream in = new URL(url).openStream();
        Files.copy(in, Paths.get(filename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        return filename;
    }

    public static boolean isValidId(String id) {
        return id.startsWith("PGS") && id.length() == 9 && !id.endsWith(".txt.gz");
    }
}

