/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.FileUtil;
import genepi.io.table.reader.CsvTableReader;
import genepi.io.table.reader.ITableReader;
import genepi.riskscore.io.Chunk;
import genepi.riskscore.io.PGSCatalog;
import genepi.riskscore.io.formats.RiskScoreFormatFactory;
import genepi.riskscore.io.formats.RiskScoreFormatImpl;
import genepi.riskscore.model.ReferenceVariant;
import genepi.riskscore.tasks.ResolveScoreTask;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lukfor.progress.TaskService;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.Task;

public class RiskScoreFile {
    private String filename;
    private Map<Integer, ReferenceVariant> variants;
    private int totalVariants = 0;
    private int ignoredVariants = 0;
    private RiskScoreFormatImpl format;

    public RiskScoreFile(String filename, String dbsnp) throws Exception {
        this(filename, RiskScoreFormatFactory.RiskScoreFormat.PGS_CATALOG, dbsnp);
    }

    public RiskScoreFile(String filename, RiskScoreFormatFactory.RiskScoreFormat format, String dbsnp) throws Exception {
        this.filename = filename;
        this.variants = new HashMap<Integer, ReferenceVariant>();
        if (!new File(filename).exists()) {
            if (PGSCatalog.isValidId(filename)) {
                String id = filename;
                this.filename = PGSCatalog.getFilenameById(id);
            } else {
                throw new Exception("File '" + filename + "' not found.");
            }
        }
        this.format = RiskScoreFormatFactory.buildFormat(this.filename, format);
        if (this.format.hasRsIds()) {
            if (dbsnp == null) {
                throw new IOException("File " + this.filename + " is in RS_ID format. Please specify dbsnp index.");
            }
            String originalFilename = this.filename;
            this.filename = String.valueOf(originalFilename) + ".positions";
            ResolveScoreTask convertRsIds = new ResolveScoreTask(originalFilename, this.filename, dbsnp);
            TaskService.setAnsiSupport((boolean)false);
            TaskService.setAnimated((boolean)false);
            List result = TaskService.run((ITaskRunnable[])new ITaskRunnable[]{convertRsIds});
            if (!((Task)result.get(0)).getStatus().isSuccess()) {
                throw new IOException(((Task)result.get(0)).getStatus().getThrowable());
            }
        }
        DataInputStream in = this.openTxtOrGzipStream(this.filename);
        CsvTableReader reader = new CsvTableReader(in, '\t');
        this.checkFileFormat((ITableReader)reader, this.filename);
        reader.close();
    }

    private void checkFileFormat(ITableReader reader, String filename) throws Exception {
        if (!reader.hasColumn(this.format.getChromosome())) {
            throw new Exception("Column '" + this.format.getChromosome() + "' not found in '" + filename + "'");
        }
        if (!reader.hasColumn(this.format.getPosition())) {
            throw new Exception("Column '" + this.format.getPosition() + "' not found in '" + filename + "'");
        }
        if (!reader.hasColumn(this.format.getEffectWeight())) {
            throw new Exception("Column '" + this.format.getEffectWeight() + "' not found in '" + filename + "'");
        }
        if (!reader.hasColumn(this.format.getOtherAllele())) {
            throw new Exception("Column '" + this.format.getOtherAllele() + "' not found in '" + filename + "'");
        }
        if (!reader.hasColumn(this.format.getEffectAllele())) {
            throw new Exception("Column '" + this.format.getEffectAllele() + "' not found in '" + filename + "'");
        }
    }

    public void buildIndex(String chromosome) throws IOException {
        this.buildIndex(chromosome, new Chunk());
    }

    public void buildIndex(String chromosome, Chunk chunk) throws IOException {
        assert (chromosome != null);
        try {
            DataInputStream in = this.openTxtOrGzipStream(this.filename);
            CsvTableReader reader = new CsvTableReader(in, '\t');
            while (reader.next()) {
                int row = ++this.totalVariants;
                String chromsomeVariant = reader.getString(this.format.getChromosome());
                if (!chromsomeVariant.equals(chromosome)) continue;
                if (reader.getString(this.format.getPosition()).isEmpty()) {
                    System.out.println("Warning: Row " + row + ": Position is empty. Ignore variant.");
                    ++this.ignoredVariants;
                    continue;
                }
                int position = 0;
                try {
                    position = reader.getInteger(this.format.getPosition());
                }
                catch (NumberFormatException e) {
                    System.out.println("Warning: Row " + row + ": '" + reader.getString(this.format.getPosition()) + "' is an invalid position. Ignore variant.");
                    ++this.ignoredVariants;
                    continue;
                }
                if (position < chunk.getStart() || position > chunk.getEnd()) continue;
                float effectWeight = 0.0f;
                try {
                    effectWeight = Double.valueOf(reader.getDouble(this.format.getEffectWeight())).floatValue();
                }
                catch (NumberFormatException e) {
                    System.out.println("Warning: Row " + row + ": '" + reader.getString(this.format.getEffectWeight()) + "' is an invalid weight. Ignore variant.");
                    ++this.ignoredVariants;
                    continue;
                }
                String rawOtherA = reader.getString(this.format.getOtherAllele());
                if (rawOtherA.isEmpty()) {
                    System.out.println("Warning: Row " + row + ": Other allele is empty. Ignore variant.");
                    ++this.ignoredVariants;
                    continue;
                }
                char alleleA = rawOtherA.charAt(0);
                String rawEffectAllele = reader.getString(this.format.getEffectAllele());
                if (rawEffectAllele.isEmpty()) {
                    System.out.println("Warning: Row " + row + ": Effect allele is empty. Ignore variant.");
                    ++this.ignoredVariants;
                    continue;
                }
                char effectAllele = rawEffectAllele.charAt(0);
                ReferenceVariant variant = new ReferenceVariant(alleleA, effectAllele, effectWeight);
                this.variants.put(position, variant);
            }
            reader.close();
        }
        catch (Exception e) {
            throw new IOException("Build Index for '" + this.filename + "' and chr '" + chromosome + "' failed: " + e.getMessage(), e);
        }
    }

    public boolean contains(int position) {
        return this.variants.containsKey(position);
    }

    public ReferenceVariant getVariant(int position) {
        return this.variants.get(position);
    }

    public static String getName(String filename) throws Exception {
        if (PGSCatalog.isValidId(filename)) {
            return filename;
        }
        String name = FileUtil.getFilename((String)filename);
        name = name.replaceAll(".txt.gz", "");
        name = name.replaceAll(".txt", "");
        name = name.replaceAll(".csv.gz", "");
        name = name.replaceAll(".csv", "");
        return name;
    }

    public int getCacheSize() {
        return this.variants.size();
    }

    public int getTotalVariants() {
        return this.totalVariants;
    }

    private DataInputStream openTxtOrGzipStream(String filename) throws IOException {
        FileInputStream inputStream = new FileInputStream(filename);
        InputStream in2 = FileUtil.decompressStream((InputStream)inputStream);
        return new DataInputStream(in2);
    }

    public String toString() {
        return this.format.toString();
    }

    public RiskScoreFormatImpl getFormat() {
        return this.format;
    }

    public int getIgnoredVariants() {
        return this.ignoredVariants;
    }
}

