/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.table.reader.CsvTableReader;
import genepi.io.table.reader.ITableReader;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class SamplesFile {
    private String filename;
    private Set<String> samples;
    private int totalSamples = 0;
    public static final char SEPARATOR = '\t';

    public SamplesFile(String filename) throws Exception {
        this.filename = filename;
        this.samples = new HashSet<String>();
        if (!new File(filename).exists()) {
            throw new Exception("File '" + filename + "' not found.");
        }
        CsvTableReader reader = new CsvTableReader(filename, '\t');
        this.checkFileFormat((ITableReader)reader, filename);
        reader.close();
    }

    private void checkFileFormat(ITableReader reader, String filename) throws Exception {
        if (!reader.hasColumn("sample")) {
            throw new Exception("Column 'sample' not found in '" + filename + "'");
        }
    }

    public void buildIndex() throws IOException {
        CsvTableReader reader = new CsvTableReader(this.filename, '\t');
        while (reader.next()) {
            String sample = reader.getString("sample");
            this.samples.add(sample);
            ++this.totalSamples;
        }
        reader.close();
    }

    public boolean contains(String sample) {
        return this.samples.contains(sample);
    }

    public int getTotalSamples() {
        return this.totalSamples;
    }
}

