/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io;

import genepi.io.table.reader.CsvTableReader;
import genepi.io.table.reader.ITableReader;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class VariantFile {
    private String filename;
    private Set<Integer> variants;
    private int totalVariants = 0;
    public static final char SEPARATOR = '\t';
    public static final String CHROMOSOME = "chr_name";
    public static final String POSITION = "chr_position";

    public VariantFile(String filename) throws Exception {
        this.filename = filename;
        this.variants = new HashSet<Integer>();
        if (!new File(filename).exists()) {
            throw new Exception("File '" + filename + "' not found.");
        }
        CsvTableReader reader = new CsvTableReader(filename, '\t');
        this.checkFileFormat((ITableReader)reader, filename);
        reader.close();
    }

    private void checkFileFormat(ITableReader reader, String filename) throws Exception {
        if (!reader.hasColumn(CHROMOSOME)) {
            throw new Exception("Column 'chr_name' not found in '" + filename + "'");
        }
        if (!reader.hasColumn(POSITION)) {
            throw new Exception("Column 'chr_position' not found in '" + filename + "'");
        }
    }

    public void buildIndex(String chromosome) throws IOException {
        CsvTableReader reader = new CsvTableReader(this.filename, '\t');
        while (reader.next()) {
            String chromsomeVariant = reader.getString(CHROMOSOME);
            if (chromsomeVariant.equals(chromosome)) {
                int position = reader.getInteger(POSITION);
                this.variants.add(position);
            }
            ++this.totalVariants;
        }
        reader.close();
    }

    public boolean contains(int position) {
        return this.variants.contains(position);
    }

    public int getCacheSize() {
        return this.variants.size();
    }

    public int getTotalVariants() {
        return this.totalVariants;
    }
}

