/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io.dbsnp;

import htsjdk.tribble.readers.TabixReader;
import java.io.IOException;

public class DbSnpReader {
    private TabixReader reader;

    public DbSnpReader(String input) throws IOException {
        this.reader = new TabixReader(input);
    }

    public Snp getByRsId(String rs) throws IOException {
        TabixReader.Iterator result = this.reader.query(DbSnpReader.getContig(rs), DbSnpReader.getPosition(rs) - 1, DbSnpReader.getPosition(rs));
        String line = result.next();
        if (line != null) {
            String[] tiles = line.split("\t");
            if (tiles.length == 6) {
                Snp snp = new Snp();
                snp.setChromosome(tiles[2]);
                snp.setPosition(Integer.parseInt(tiles[3]));
                snp.setReference(tiles[4].replaceAll("\\*", ""));
                snp.setAlternate(tiles[5]);
                return snp;
            }
            throw new IOException("Index has not 6 columns.");
        }
        return null;
    }

    public void close() {
        this.reader.close();
    }

    public static String getContig(String rsID) {
        if (rsID.length() > 10) {
            return rsID.substring(0, 3);
        }
        return "rs";
    }

    public static int getPosition(String rsID) {
        if (rsID.length() > 10) {
            return Integer.parseInt(rsID.substring(3));
        }
        return Integer.parseInt(rsID.substring(2));
    }

    public class Snp {
        private String chromosome;
        private long position;
        private String reference;
        private String alternate;

        public String getChromosome() {
            return this.chromosome;
        }

        public void setChromosome(String chromosome) {
            this.chromosome = chromosome;
        }

        public long getPosition() {
            return this.position;
        }

        public void setPosition(long position) {
            this.position = position;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public String getReference() {
            return this.reference;
        }

        public void setAlternate(String alternate) {
            this.alternate = alternate;
        }

        public String getAlternate() {
            return this.alternate;
        }

        public String toString() {
            return String.valueOf(this.chromosome) + ":" + this.position + ":" + this.reference;
        }
    }
}

