/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io.formats;

import genepi.io.FileUtil;
import genepi.io.table.reader.CsvTableReader;
import genepi.riskscore.io.formats.PGSCatalogVariantsFormat;
import genepi.riskscore.io.formats.RiskScoreFormatImpl;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PGSCatalogFormat
extends RiskScoreFormatImpl {
    public int VERSION_1 = 1;
    public int VERSION_2 = 2;
    private int version = this.VERSION_1;
    private PGSCatalogVariantsFormat format;

    public PGSCatalogFormat(String filename) throws IOException {
        this.format = this.detectVersionAndFormat(filename);
        if (this.format == PGSCatalogVariantsFormat.UNKNOWN || this.format == PGSCatalogVariantsFormat.RS_ID) {
            this.version = this.VERSION_2;
            this.format = this.detectVersionAndFormat(filename);
        }
    }

    @Override
    public String getChromosome() {
        return "chr_name";
    }

    @Override
    public String getPosition() {
        return "chr_position";
    }

    @Override
    public String getEffectAllele() {
        return "effect_allele";
    }

    @Override
    public String getEffectWeight() {
        return "effect_weight";
    }

    @Override
    public String getOtherAllele() {
        if (this.version == this.VERSION_2) {
            return "other_allele";
        }
        return "reference_allele";
    }

    protected PGSCatalogVariantsFormat detectVersionAndFormat(String filename) throws IOException {
        DataInputStream in = PGSCatalogFormat.openTxtOrGzipStream(filename);
        CsvTableReader reader = new CsvTableReader(in, '\t');
        reader.close();
        if (!reader.hasColumn("rsID")) {
            if (!reader.hasColumn(this.getChromosome())) {
                return PGSCatalogVariantsFormat.UNKNOWN;
            }
            if (!reader.hasColumn(this.getPosition())) {
                return PGSCatalogVariantsFormat.UNKNOWN;
            }
            if (!reader.hasColumn(this.getOtherAllele())) {
                return PGSCatalogVariantsFormat.UNKNOWN;
            }
            return PGSCatalogVariantsFormat.COORDINATES;
        }
        if (!reader.hasColumn(this.getEffectWeight())) {
            return PGSCatalogVariantsFormat.UNKNOWN;
        }
        if (!reader.hasColumn(this.getEffectAllele())) {
            return PGSCatalogVariantsFormat.UNKNOWN;
        }
        if (reader.hasColumn(this.getChromosome()) && reader.hasColumn(this.getPosition()) && reader.hasColumn(this.getOtherAllele())) {
            return PGSCatalogVariantsFormat.COORDINATES;
        }
        return PGSCatalogVariantsFormat.RS_ID;
    }

    public PGSCatalogVariantsFormat getFormat() {
        return this.format;
    }

    public String toString() {
        return "PGS-Catalog v" + this.version + " (" + (Object)((Object)this.format) + ")";
    }

    private static DataInputStream openTxtOrGzipStream(String filename) throws IOException {
        FileInputStream inputStream = new FileInputStream(filename);
        InputStream in2 = FileUtil.decompressStream((InputStream)inputStream);
        return new DataInputStream(in2);
    }

    @Override
    public boolean hasRsIds() {
        return this.format == PGSCatalogVariantsFormat.RS_ID;
    }
}

