/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io.vcf;

import genepi.io.text.LineReader;
import genepi.riskscore.io.vcf.MinimalVariantContext;
import genepi.riskscore.io.vcf.VCFLineParser;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;

public class FastVCFFileReader
extends LineReader {
    private List<String> samples;
    private int snpsCount = 0;
    private int samplesCount = 0;
    private MinimalVariantContext variantContext;
    private List<String> header = new Vector<String>();
    private VCFLineParser parser;

    public FastVCFFileReader(InputStream stream, String vcfFilename) throws IOException {
        super(new DataInputStream(stream));
        VCFFileReader reader = new VCFFileReader(new File(vcfFilename), false);
        VCFHeader header = reader.getFileHeader();
        this.samples = header.getGenotypeSamples();
        this.samplesCount = this.samples.size();
        this.variantContext = new MinimalVariantContext(this.samplesCount);
        reader.close();
        this.parser = new VCFLineParser(this.samplesCount);
    }

    public List<String> getGenotypedSamples() {
        return this.samples;
    }

    public MinimalVariantContext getVariantContext() {
        return this.variantContext;
    }

    public int getSnpsCount() {
        return this.snpsCount;
    }

    public int getSamplesCount() {
        return this.samplesCount;
    }

    protected void parseLine(String line) throws IOException {
        if (line.charAt(0) != '#') {
            this.variantContext = this.parser.parseLine(line);
            if (this.variantContext.getNSamples() != this.samplesCount) {
                throw new IOException("Line " + this.getLineNumber() + ": different number of samples.");
            }
            ++this.snpsCount;
        } else {
            this.header.add(line);
            this.next();
        }
    }

    public List<String> getFileHeader() {
        return this.header;
    }
}

