/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.io.vcf;

import genepi.riskscore.io.vcf.MinimalVariantContext;
import java.io.IOException;

public class VCFLineParser {
    private int samplesInLineCount = 0;
    private int noCallCount = 0;
    private int hetCount = 0;
    private int homRefCount = 0;
    private int homVarCount = 0;
    private int i = 0;
    private int countR = 0;
    private int countV = 0;
    private int countNo = 0;
    private int tile = 0;
    private int tileGT = 0;
    private int j = 0;
    private int k = 0;
    private MinimalVariantContext variantContext;
    private int samples;

    public VCFLineParser(int samples) {
        this.variantContext = new MinimalVariantContext(samples);
        this.samples = samples;
    }

    public MinimalVariantContext parseLine(String line) throws IOException {
        String[] tiles = line.split("\t", 10);
        if (tiles.length < 10) {
            throw new IOException("The provided VCF file is not correct tab-delimited");
        }
        String chromosome = tiles[0];
        int position = Integer.parseInt(tiles[1]);
        String ref = tiles[3];
        String alt = tiles[4];
        this.variantContext.setContig(chromosome);
        this.variantContext.setStart(position);
        this.variantContext.setReferenceAllele(ref);
        this.variantContext.setAlternateAllele(alt);
        this.variantContext.setHetCount(this.hetCount);
        this.variantContext.setHomRefCount(this.homRefCount);
        this.variantContext.setHomVarCount(this.homVarCount);
        this.variantContext.setNoCallCount(this.noCallCount);
        this.variantContext.setNSamples(this.samples);
        this.variantContext.setRawLine(line);
        if (!tiles[6].equals("PASS") && !tiles[6].equals(".")) {
            this.variantContext.setFilters(tiles[6]);
        } else {
            this.variantContext.setFilters(null);
        }
        this.variantContext.setInfo(tiles[7]);
        return this.variantContext;
    }
}

