/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.model;

import java.text.DecimalFormat;

public class RiskScoreSummary {
    private String name;
    private int variants = 0;
    private int variantsUsed = 0;
    private int variantsIgnored = 0;
    private double coverage = 0.0;
    private int variantsSwitched = 0;
    private int variantsMultiAllelic = 0;
    private int variantsAlleleMissmatch = 0;
    private int r2Filtered = 0;
    private int notFound = 0;
    private int filtered = 0;
    private Object meta;
    private Object data;
    private String coverageLabel;

    public RiskScoreSummary(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getVariantsUsed() {
        return this.variantsUsed;
    }

    public void incVariantsUsed() {
        ++this.variantsUsed;
        this.coverage = this.getVariantsUsed() / this.getVariants();
    }

    public int getSwitched() {
        return this.variantsSwitched;
    }

    public void incSwitched() {
        ++this.variantsSwitched;
    }

    public int getMultiAllelic() {
        return this.variantsMultiAllelic;
    }

    public void incMultiAllelic() {
        ++this.variantsMultiAllelic;
    }

    public int getAlleleMissmatch() {
        return this.variantsAlleleMissmatch;
    }

    public void incAlleleMissmatch() {
        ++this.variantsAlleleMissmatch;
    }

    public int getR2Filtered() {
        return this.r2Filtered;
    }

    public void incR2Filtered() {
        ++this.r2Filtered;
    }

    public int getVariants() {
        return this.variants;
    }

    public void setVariants(int count) {
        this.variants = count;
        this.coverage = this.getVariantsUsed() / this.getVariants();
    }

    public int getNotFound() {
        return this.notFound;
    }

    public void incNotFound() {
        ++this.notFound;
    }

    public int getFiltered() {
        return this.filtered;
    }

    public void incFiltered() {
        ++this.filtered;
    }

    public int getVariantsNotUsed() {
        return this.variants - this.variantsUsed;
    }

    public void setCoverage(double coverage) {
    }

    public double getCoverage() {
        return this.coverage;
    }

    public void setMeta(Object meta) {
        this.meta = meta;
    }

    public Object getMeta() {
        return this.meta;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void setCoverageLabel(String coverageLabel) {
    }

    public String getCoverageLabel() {
        return this.coverageLabel;
    }

    public void setVariantsIgnored(int variantsIgnored) {
        this.variantsIgnored = variantsIgnored;
    }

    public int getVariantsIgnored() {
        return this.variantsIgnored;
    }

    public void updateStatistics() {
        this.coverage = (double)this.getVariantsUsed() / (double)this.getVariants();
        this.coverageLabel = this.getVariantsUsed() == 0 ? "zero" : (this.coverage <= 0.25 ? "low" : (this.coverage > 0.25 && this.coverage <= 0.75 ? "medium" : "high"));
    }

    public void merge(RiskScoreSummary other) throws Exception {
        if (!other.name.equals(this.name)) {
            throw new Exception("Different score names: '" + this.name + "' vs. '" + other.name + "'.");
        }
        this.variantsUsed += other.variantsUsed;
        this.variantsIgnored += other.variantsIgnored;
        this.variantsSwitched += other.variantsSwitched;
        this.variantsMultiAllelic += other.variantsMultiAllelic;
        this.variantsAlleleMissmatch += other.variantsAlleleMissmatch;
        this.r2Filtered += other.r2Filtered;
        this.notFound += other.notFound;
        this.filtered += other.filtered;
        this.updateStatistics();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  " + this.name + ":\n");
        buffer.append("    - Variants: " + RiskScoreSummary.number(this.getVariants()) + "\n");
        buffer.append("    - Variants ignored: " + RiskScoreSummary.number(this.getVariantsIgnored()) + "\n");
        buffer.append("    - Variants used: " + RiskScoreSummary.number(this.getVariantsUsed()) + " (" + RiskScoreSummary.percentage(this.getVariantsUsed(), this.getVariants()) + ")\n");
        buffer.append("    - Found in target and filtered by:\n");
        buffer.append("      - allele mismatch: " + RiskScoreSummary.number(this.getAlleleMissmatch()) + "\n");
        buffer.append("      - multi allelic or indels: " + RiskScoreSummary.number(this.getMultiAllelic()) + "\n");
        buffer.append("      - low R2 value: " + RiskScoreSummary.number(this.getR2Filtered()) + "\n");
        buffer.append("      - variants file: " + RiskScoreSummary.number(this.getFiltered()) + "\n");
        int notFound = this.getVariants() - (this.getVariantsUsed() + this.getFiltered() + this.getAlleleMissmatch() + this.getMultiAllelic() + this.getR2Filtered());
        return buffer.toString();
    }

    public static String number(long number) {
        DecimalFormat formatter = new DecimalFormat("###,###,###");
        return formatter.format(number);
    }

    public static String percentage(double obtained, double total) {
        double percentage = obtained / total * 100.0;
        DecimalFormat df = new DecimalFormat("###.##'%'");
        return df.format(percentage);
    }
}

