/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.tasks;

import genepi.io.table.writer.CsvTableWriter;
import genepi.riskscore.io.Chunk;
import genepi.riskscore.io.OutputFileWriter;
import genepi.riskscore.io.ReportFile;
import genepi.riskscore.io.RiskScoreFile;
import genepi.riskscore.io.SamplesFile;
import genepi.riskscore.io.VariantFile;
import genepi.riskscore.io.formats.RiskScoreFormatFactory;
import genepi.riskscore.io.vcf.FastVCFFileReader;
import genepi.riskscore.model.RiskScore;
import genepi.riskscore.model.RiskScoreSummary;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.monitors.ITaskMonitor;
import lukfor.progress.util.CountingInputStream;

public class ApplyScoreTask
implements ITaskRunnable {
    private List<RiskScore> riskScores;
    private String vcf = null;
    private String[] riskScoreFilenames = null;
    private int countSamples = 0;
    private int countVariants = 0;
    private Chunk chunk = null;
    private float minR2 = 0.0f;
    private String outputVariantFilename = null;
    private String includeVariantFilename = null;
    private String includeSamplesFilename = null;
    private String outputReportFilename = null;
    private CsvTableWriter variantFile;
    private RiskScoreFormatFactory.RiskScoreFormat defaultFormat = RiskScoreFormatFactory.RiskScoreFormat.PGS_CATALOG;
    private Map<String, RiskScoreFormatFactory.RiskScoreFormat> formats = new HashMap<String, RiskScoreFormatFactory.RiskScoreFormat>();
    private String genotypeFormat = "DS";
    private int numberRiskScores = 0;
    private RiskScoreSummary[] summaries;
    private String output;
    private String outputEffectsFilename;
    private String dbsnp = null;
    public static final String INFO_R2 = "R2";
    public static final String DOSAGE_FORMAT = "DS";

    public void setRiskScoreFilenames(String ... filenames) {
        this.riskScoreFilenames = filenames;
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            this.formats.put(filename, this.defaultFormat);
            ++n2;
        }
    }

    public void setChunk(Chunk chunk) {
        this.chunk = chunk;
    }

    public void setVcfFilename(String vcf) {
        this.vcf = vcf;
    }

    public void setOutputVariantFilename(String outputVariantFilename) {
        this.outputVariantFilename = outputVariantFilename;
    }

    public void setIncludeVariantFilename(String includeVariantFilename) {
        this.includeVariantFilename = includeVariantFilename;
    }

    public void setIncludeSamplesFilename(String includeSamplesFilename) {
        this.includeSamplesFilename = includeSamplesFilename;
    }

    public void setGenotypeFormat(String genotypeFormat) {
        this.genotypeFormat = genotypeFormat;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setOutputReportFilename(String outputReportFilename) {
        this.outputReportFilename = outputReportFilename;
    }

    public void setOutputEffectsFilename(String outputEffectsFilename) {
        this.outputEffectsFilename = outputEffectsFilename;
    }

    public void setDbSnp(String dbsnp) {
        this.dbsnp = dbsnp;
    }

    public void run(ITaskMonitor monitor) throws Exception {
        if (this.vcf == null || this.vcf.isEmpty()) {
            throw new Exception("Please specify a vcf file.");
        }
        if (this.output == null || this.output.isEmpty()) {
            throw new Exception("Please specify a output filename.");
        }
        if (this.riskScoreFilenames == null || this.riskScoreFilenames.length == 0) {
            throw new Exception("Reference can not be null or empty.");
        }
        if (this.outputVariantFilename != null) {
            this.variantFile = new CsvTableWriter(this.outputVariantFilename, '\t');
            this.variantFile.setColumns(new String[]{"chr_name", "chr_position"});
        }
        String chromosome = null;
        FastVCFFileReader vcfReader = new FastVCFFileReader(new FileInputStream(this.vcf), this.vcf);
        if (!vcfReader.next()) {
            vcfReader.close();
            throw new Exception("VCF file is empty.");
        }
        chromosome = vcfReader.getVariantContext().getContig();
        vcfReader.close();
        String taskName = "[Chr " + (chromosome.length() == 1 ? "0" : "") + chromosome + "]";
        monitor.begin(taskName, new File(this.vcf).length());
        monitor.worked(0L);
        this.numberRiskScores = this.riskScoreFilenames.length;
        this.summaries = new RiskScoreSummary[this.numberRiskScores];
        int i = 0;
        while (i < this.numberRiskScores) {
            String name = RiskScoreFile.getName(this.riskScoreFilenames[i]);
            this.summaries[i] = new RiskScoreSummary(name);
            ++i;
        }
        RiskScoreFile[] riskscores = this.loadReferenceFiles(monitor, chromosome, this.dbsnp, this.riskScoreFilenames);
        boolean empty = true;
        RiskScoreFile[] riskScoreFileArray = riskscores;
        int n = riskscores.length;
        int n2 = 0;
        while (n2 < n) {
            RiskScoreFile riskscore = riskScoreFileArray[n2];
            if (riskscore.getCacheSize() > 0) {
                empty = false;
                break;
            }
            ++n2;
        }
        if (!empty) {
            this.processVCF(monitor, chromosome, this.vcf, riskscores);
            if (this.variantFile != null) {
                this.variantFile.close();
            }
            OutputFileWriter outputFile = new OutputFileWriter(this.riskScores, this.summaries);
            outputFile.save(this.output);
            if (this.outputReportFilename != null) {
                ReportFile reportFile = new ReportFile(this.summaries);
                reportFile.save(this.outputReportFilename);
            }
        }
        monitor.done();
    }

    private RiskScoreFile[] loadReferenceFiles(ITaskMonitor monitor, String chromosome, String dbsnp, String ... riskScoreFilenames) throws Exception {
        RiskScoreFile[] riskscores = new RiskScoreFile[this.numberRiskScores];
        int i = 0;
        while (i < this.numberRiskScores) {
            RiskScoreFormatFactory.RiskScoreFormat format = this.formats.get(riskScoreFilenames[i]);
            RiskScoreFile riskscore = new RiskScoreFile(riskScoreFilenames[i], format, dbsnp);
            if (this.chunk != null) {
                riskscore.buildIndex(chromosome, this.chunk);
            } else {
                riskscore.buildIndex(chromosome);
            }
            this.summaries[i].setVariants(riskscore.getTotalVariants());
            this.summaries[i].setVariantsIgnored(riskscore.getIgnoredVariants());
            riskscores[i] = riskscore;
            monitor.worked(0L);
            ++i;
        }
        return riskscores;
    }

    /*
     * Unable to fully structure code
     */
    private void processVCF(ITaskMonitor monitor, String chromosome, String vcfFilename, RiskScoreFile[] riskscores) throws Exception {
        includeVariants = null;
        if (this.includeVariantFilename != null) {
            includeVariants = new VariantFile(this.includeVariantFilename);
            includeVariants.buildIndex(chromosome);
        }
        samplesFile = null;
        if (this.includeSamplesFilename != null) {
            samplesFile = new SamplesFile(this.includeSamplesFilename);
            samplesFile.buildIndex();
        }
        countingStream = new CountingInputStream((InputStream)new FileInputStream(vcfFilename), monitor);
        vcfReader = new FastVCFFileReader((InputStream)countingStream, vcfFilename);
        this.countSamples = vcfReader.getGenotypedSamples().size();
        this.riskScores = new Vector<RiskScore>();
        i = 0;
        while (i < this.countSamples) {
            sample = vcfReader.getGenotypedSamples().get(i);
            if (samplesFile == null || samplesFile.contains(sample)) {
                riskScore = new RiskScore(chromosome, sample, this.riskScoreFilenames.length);
                this.riskScores.add(riskScore);
            }
            ++i;
        }
        outOfChunk = false;
        effectsWriter = null;
        if (this.outputEffectsFilename != null) {
            effectsWriter = new CsvTableWriter(this.outputEffectsFilename, ',');
            effectsWriter.setColumns(new String[]{"score", "sample", "chr_name", "chr_position", "effect"});
        }
        while (vcfReader.next() && !outOfChunk) {
            if (monitor.isCanceled()) {
                return;
            }
            variant = vcfReader.getVariantContext();
            ++this.countVariants;
            if (!variant.getContig().equals(chromosome)) {
                vcfReader.close();
                throw new Exception("Different chromosomes found in file.");
            }
            position = variant.getStart();
            if (this.chunk != null) {
                if (position < this.chunk.getStart()) continue;
                if (position > this.chunk.getEnd()) {
                    outOfChunk = true;
                    continue;
                }
            }
            j = 0;
            while (j < this.riskScoreFilenames.length) {
                block20: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block19: {
                                            summary = this.summaries[j];
                                            riskscore = riskscores[j];
                                            isPartOfRiskScore = riskscore.contains(position);
                                            if (isPartOfRiskScore) break block19;
                                            summary.incNotFound();
                                            break block20;
                                        }
                                        if (includeVariants == null || includeVariants.contains(position)) break block21;
                                        summary.incFiltered();
                                        break block20;
                                    }
                                    r2 = variant.getInfoAsDouble("R2", 0.0);
                                    if (!(r2 < (double)this.minR2)) break block22;
                                    summary.incR2Filtered();
                                    break block20;
                                }
                                referenceVariant = riskscore.getVariant(position);
                                if (!variant.isComplexIndel()) break block23;
                                summary.incMultiAllelic();
                                break block20;
                            }
                            effectWeight = referenceVariant.getEffectWeight();
                            referenceAllele = variant.getReferenceAllele().charAt(0);
                            if (variant.getAlternateAllele().length() != 0) break block24;
                            summary.incMultiAllelic();
                            break block20;
                        }
                        alternateAllele = variant.getAlternateAllele().charAt(0);
                        if (referenceVariant.hasAllele(referenceAllele) && referenceVariant.hasAllele(alternateAllele)) break block25;
                        summary.incAlleleMissmatch();
                        break block20;
                    }
                    if (referenceVariant.isEffectAllele(alternateAllele)) ** GOTO lbl81
                    if (!referenceVariant.isEffectAllele(referenceAllele)) {
                        summary.incAlleleMissmatch();
                    } else {
                        effectWeight = -effectWeight;
                        summary.incSwitched();
lbl81:
                        // 2 sources

                        if (referenceVariant.isUsed()) {
                            System.out.println(String.valueOf(variant.getContig()) + " " + variant.getStart());
                        }
                        referenceVariant.setUsed(true);
                        if (this.variantFile != null) {
                            this.variantFile.setString("chr_name", variant.getContig());
                            this.variantFile.setInteger("chr_position", variant.getStart());
                            this.variantFile.next();
                        }
                        dosages = variant.getGenotypeDosages(this.genotypeFormat);
                        indexSample = 0;
                        i = 0;
                        while (i < this.countSamples) {
                            sample = vcfReader.getGenotypedSamples().get(i);
                            if ((samplesFile == null || samplesFile.contains(sample)) && (dosage = dosages[i]) >= 0.0f) {
                                effect = dosage * effectWeight;
                                this.riskScores.get(indexSample).incScore(j, effect);
                                ++indexSample;
                                if (effectsWriter != null) {
                                    effectsWriter.setString("score", summary.getName());
                                    effectsWriter.setString("sample", sample);
                                    effectsWriter.setString("chr_name", variant.getContig());
                                    effectsWriter.setInteger("chr_position", variant.getStart());
                                    effectsWriter.setDouble("effect", effect);
                                    effectsWriter.next();
                                }
                            }
                            ++i;
                        }
                        summary.incVariantsUsed();
                    }
                }
                ++j;
            }
        }
        if (effectsWriter != null) {
            effectsWriter.close();
        }
        vcfReader.close();
    }

    public void setMinR2(float minR2) {
        this.minR2 = minR2;
    }

    public void setDefaultRiskScoreFormat(RiskScoreFormatFactory.RiskScoreFormat defaultFormat) {
        this.defaultFormat = defaultFormat;
        if (this.riskScoreFilenames != null) {
            String[] stringArray = this.riskScoreFilenames;
            int n = this.riskScoreFilenames.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                this.setRiskScoreFormat(file, defaultFormat);
                ++n2;
            }
        }
    }

    public void setRiskScoreFormat(String file, RiskScoreFormatFactory.RiskScoreFormat format) {
        this.formats.put(file, format);
    }

    public int getCountSamples() {
        return this.countSamples;
    }

    public RiskScoreSummary[] getSummaries() {
        return this.summaries;
    }

    int getCountVariants() {
        return this.countVariants;
    }

    public String getOutput() {
        return this.output;
    }

    public String getOutputReportFilename() {
        return this.outputReportFilename;
    }

    public String getOutputEffectsFilename() {
        return this.outputEffectsFilename;
    }
}

