/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.tasks;

import genepi.riskscore.App;
import genepi.riskscore.io.OutputFile;
import genepi.riskscore.io.ReportFile;
import java.io.File;
import java.util.Date;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.monitors.ITaskMonitor;
import lukfor.reports.HtmlReport;

public class CreateHtmlReportTask
implements ITaskRunnable {
    public static final String TEMPLATE_DIRECTORY = "/templates";
    public static final String REPORT_TEMPLATE = "report.html";
    private String output;
    private ReportFile report;
    private OutputFile data;

    public void setOutput(String output) {
        this.output = output;
    }

    public void setReport(ReportFile report) {
        this.report = report;
    }

    public void setData(OutputFile data) {
        this.data = data;
    }

    public void run(ITaskMonitor monitor) throws Exception {
        monitor.begin("Create HTML Report", -1L);
        assert (this.report != null);
        assert (this.output != null);
        assert (this.data != null);
        HtmlReport report = new HtmlReport(TEMPLATE_DIRECTORY);
        report.setMainFilename(REPORT_TEMPLATE);
        report.set("createdOn", (Object)new Date());
        report.set("version", (Object)"0.9.16");
        report.set("application", (Object)"pgs-calc");
        report.set("application_name", (Object)"PGS-Calc");
        String args = String.join((CharSequence)"\\<br>  ", App.ARGS);
        report.set("application_args", (Object)args);
        report.set("url", (Object)"https://github.com/lukfor/pgs-calc");
        report.set("copyright", (Object)"(c) 2020 - 2022 Lukas Forer");
        report.set("samples", this.data.getSamples());
        int i = 0;
        while (i < this.report.getSummaries().size()) {
            if (this.report.getSummaries().get(i).getVariantsUsed() > 0) {
                this.report.getSummaries().get(i).setData(this.data.getValuesByScore(i));
            }
            this.report.getSummaries().get(i).updateStatistics();
            ++i;
        }
        report.set("scores", this.report.getSummaries());
        report.setSelfContained(true);
        report.generate(new File(this.output));
        monitor.update("Html Report created and written to '" + this.output + "'");
        monitor.done();
    }
}

