/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.tasks;

import genepi.riskscore.io.ReportFile;
import genepi.riskscore.model.RiskScoreSummary;
import genepi.riskscore.tasks.ApplyScoreTask;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.monitors.ITaskMonitor;

public class MergeReportTask
implements ITaskRunnable {
    private String output;
    private List<ReportFile> inputs = new Vector<ReportFile>();
    private ReportFile result;

    public void setOutput(String output) {
        this.output = output;
    }

    public void setInputs(String ... filenames) throws IOException {
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (new File(filename).exists()) {
                this.inputs.add(ReportFile.loadFromFile(filename));
            }
            ++n2;
        }
    }

    public void setInputs(List<ApplyScoreTask> tasks) {
        int i = 0;
        while (i < tasks.size()) {
            ApplyScoreTask task = tasks.get(i);
            String filename = task.getOutput();
            if (new File(filename).exists()) {
                this.inputs.add(new ReportFile(task.getSummaries()));
            }
            ++i;
        }
    }

    public void run(ITaskMonitor monitor) throws Exception {
        monitor.begin("Merge report files");
        if (this.inputs.isEmpty()) {
            throw new Exception("No chunks found to merge.");
        }
        this.result = this.inputs.get(0);
        int i = 1;
        while (i < this.inputs.size()) {
            this.result.merge(this.inputs.get(i));
            ++i;
        }
        for (RiskScoreSummary summary : this.result.getSummaries()) {
            summary.updateStatistics();
        }
        if (this.output != null) {
            this.result.save(this.output);
            monitor.update("Report files merged and written to '" + this.output + "'");
        } else {
            monitor.update("Report files merged");
        }
        monitor.done();
        this.inputs = null;
    }

    public ReportFile getResult() {
        return this.result;
    }
}

