/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.tasks;

import genepi.io.table.writer.CsvTableWriter;
import genepi.riskscore.io.OutputFileReader;
import genepi.riskscore.tasks.ApplyScoreTask;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.monitors.ITaskMonitor;

public class MergeScoreTask
implements ITaskRunnable {
    private String output;
    private List<String> inputs = new Vector<String>();

    public void setOutput(String output) {
        this.output = output;
    }

    public void setInputs(String ... filenames) throws IOException {
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (new File(filename).exists()) {
                this.inputs.add(filename);
            }
            ++n2;
        }
    }

    public void setInputs(List<ApplyScoreTask> tasks) {
        int i = 0;
        while (i < tasks.size()) {
            ApplyScoreTask task = tasks.get(i);
            String filename = task.getOutput();
            if (new File(filename).exists()) {
                this.inputs.add(filename);
            }
            ++i;
        }
    }

    public void run(ITaskMonitor monitor) throws Exception {
        monitor.begin("Merge score files");
        assert (this.output != null);
        if (this.inputs.isEmpty()) {
            throw new Exception("No chunks found to merge.");
        }
        OutputFileReader[] files = new OutputFileReader[this.inputs.size()];
        int i = 0;
        while (i < this.inputs.size()) {
            files[i] = new OutputFileReader(this.inputs.get(i));
            ++i;
        }
        List<String> scores = files[0].getScores();
        String[] columns = new String[scores.size() + 1];
        columns[0] = "sample";
        int i2 = 0;
        while (i2 < scores.size()) {
            columns[i2 + 1] = scores.get(i2);
            ++i2;
        }
        CsvTableWriter writer = new CsvTableWriter(this.output, ',');
        writer.setColumns(columns);
        while (files[0].next()) {
            double[] values = files[0].getValues();
            int i3 = 1;
            while (i3 < files.length) {
                if (!files[i3].next()) {
                    throw new Exception("Not all vcf files have the same number of samples.");
                }
                double[] data = files[i3].getValues();
                int j = 0;
                while (j < data.length) {
                    int n = j;
                    values[n] = values[n] + data[j];
                    ++j;
                }
                ++i3;
            }
            writer.setString("sample", files[0].getSample());
            i3 = 0;
            while (i3 < scores.size()) {
                writer.setDouble(scores.get(i3), values[i3]);
                ++i3;
            }
            writer.next();
        }
        int i4 = 0;
        while (i4 < files.length) {
            files[i4].close();
            ++i4;
        }
        writer.close();
        monitor.done();
        this.inputs = null;
    }
}

