/*
 * Decompiled with CFR 0.152.
 */
package genepi.riskscore.commands;

import genepi.io.FileUtil;
import genepi.riskscore.App;
import genepi.riskscore.io.Chunk;
import genepi.riskscore.io.MetaFile;
import genepi.riskscore.io.OutputFile;
import genepi.riskscore.io.PGSCatalog;
import genepi.riskscore.io.PGSCatalogIDFile;
import genepi.riskscore.io.ReportFile;
import genepi.riskscore.io.RiskScoreFile;
import genepi.riskscore.io.SamplesFile;
import genepi.riskscore.io.ScoresFile;
import genepi.riskscore.io.formats.RiskScoreFormatFactory;
import genepi.riskscore.model.RiskScoreSummary;
import genepi.riskscore.tasks.ApplyScoreTask;
import genepi.riskscore.tasks.CreateHtmlReportTask;
import genepi.riskscore.tasks.LiftOverScoreTask;
import genepi.riskscore.tasks.MergeEffectsTask;
import genepi.riskscore.tasks.MergeReportTask;
import genepi.riskscore.tasks.MergeScoreTask;
import genepi.riskscore.tasks.MergeVariantsTask;
import genepi.riskscore.tasks.ResolveScoreTask;
import htsjdk.samtools.util.StopWatch;
import java.io.File;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import lukfor.progress.TaskService;
import lukfor.progress.renderer.IProgressIndicator;
import lukfor.progress.tasks.ITaskRunnable;
import lukfor.progress.tasks.Task;
import picocli.CommandLine;

@CommandLine.Command(name="apply", version={"1.5.1"})
public class ApplyScoreCommand
implements Callable<Integer> {
    @CommandLine.Parameters(description={"VCF files"})
    List<String> vcfs;
    @CommandLine.Option(names={"--ref"}, description={"Reference weights"}, required=true)
    String ref;
    @CommandLine.Option(names={"--out"}, description={"Output filename"}, required=true)
    String out;
    @CommandLine.Option(names={"--minR2", "--min-r2"}, description={"Minimal imputation quality"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    float minR2 = 0.0f;
    @CommandLine.Option(names={"--genotypes"}, description={"Genotype field (DS or GT)"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    String genotypeFormat = "DS";
    @CommandLine.Option(names={"--threads"}, description={"Number of threads"}, required=false)
    int threads = 1;
    @CommandLine.Option(names={"--writeVariants", "--write-variants"}, description={"Write csv file with all used variants"}, required=false)
    String outputVariantFilename = null;
    @CommandLine.Option(names={"--includeVariants", "--include-variants"}, description={"Include only variants from this file"}, required=false)
    String includeVariantFilename = null;
    @CommandLine.Option(names={"--samples"}, description={"Include only samples from this file"}, required=false)
    String includeSamplesFilename = null;
    @CommandLine.Option(names={"--report-json", "--info"}, description={"Write statistics to json file"}, required=false)
    String reportJson = null;
    @CommandLine.Option(names={"--report-csv"}, description={"Write statistics to csv file"}, required=false)
    String reportCsv = null;
    @CommandLine.Option(names={"--report-html"}, description={"Write statistics to html file"}, required=false)
    String reportHtml = null;
    @CommandLine.Option(names={"--meta"}, description={"JSON file with meta data about scores"}, required=false)
    String meta = null;
    @CommandLine.Option(names={"--writeEffects", "--write-effects"}, description={"Write file with effects per snp and sample"}, required=false)
    String outputEffectsFilename = null;
    @CommandLine.Option(names={"--dbsnp"}, description={"dbSNP Index file to support rsIDs"}, required=false)
    String dbsnp = null;
    @CommandLine.Option(names={"--proxies"}, description={"Proxy Index file"}, required=false)
    String proxies = null;
    @CommandLine.Option(names={"--fix-strand-flips"}, description={"Fix strand flips when possible"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean fixStrandFlips = false;
    @CommandLine.Option(names={"--inverse-dosage"}, description={"Use inverse dosage instead of inverse effect size."}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean inverseDosage = false;
    @CommandLine.Option(names={"--remove-ambiguous"}, description={"Remove all ambigous variants (A/T and G/C)"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean removeAmbiguous = false;
    @CommandLine.Option(names={"--help"}, usageHelp=true)
    boolean showHelp;
    @CommandLine.Option(names={"--no-ansi"}, description={"Disable ANSI output"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean noAnsi = false;
    @CommandLine.Option(names={"--verbose"}, description={"Show debug messages"}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    boolean verbose = false;
    @CommandLine.Option(names={"--version"}, versionHelp=true)
    boolean showVersion;
    @CommandLine.ArgGroup(exclusive=false, multiplicity="0..1")
    Chunk chunk;

    @Override
    public Integer call() throws Exception {
        OutputFile data;
        MetaFile metaFile;
        if (this.verbose) {
            RiskScoreFile.VERBOSE = true;
            ResolveScoreTask.VERBOSE = true;
            ApplyScoreTask.VERBOSE = true;
            LiftOverScoreTask.VERBOSE = true;
            PGSCatalog.VERBOSE = true;
            this.noAnsi = true;
        }
        if (this.noAnsi) {
            TaskService.setAnimated((boolean)false);
            TaskService.setAnsiColors((boolean)false);
        }
        if (this.vcfs == null || this.vcfs.isEmpty()) {
            System.out.println();
            System.out.println("Please provide at least one VCF file.");
            System.out.println();
            return 1;
        }
        System.out.println();
        System.out.println("Input:");
        System.out.println("  ref: " + this.ref);
        System.out.println("  out: " + this.out);
        System.out.println("  genotypes: " + this.genotypeFormat);
        System.out.println("  minR2: " + this.minR2);
        if (this.chunk != null) {
            System.out.println("  Chunk: " + this.chunk.getStart() + " - " + this.chunk.getEnd());
        }
        System.out.println("  vcfs (" + this.vcfs.size() + "):");
        for (String vcf : this.vcfs) {
            System.out.println("   - " + vcf);
        }
        System.out.println();
        StopWatch watch = new StopWatch();
        watch.start();
        String outParent = new File(this.out).getParent();
        String tempFolder = FileUtil.path((String[])new String[]{outParent, "temp"});
        File tempFolderFile = new File(tempFolder);
        tempFolderFile.mkdirs();
        Vector<ApplyScoreTask> tasks = new Vector<ApplyScoreTask>();
        for (String vcf : this.vcfs) {
            ApplyScoreTask task = new ApplyScoreTask();
            String[] refs = this.parseRef(this.ref);
            task.setRiskScoreFilenames(refs);
            for (String file : refs) {
                String autoFormat = file + ".format";
                if (!new File(autoFormat).exists()) continue;
                task.setRiskScoreFormat(file, RiskScoreFormatFactory.RiskScoreFormat.MAPPING_FILE);
            }
            if (this.chunk != null) {
                task.setChunk(this.chunk);
            }
            String taskPrefix = FileUtil.path((String[])new String[]{tempFolder, "task_" + tasks.size()});
            if (this.dbsnp != null) {
                task.setDbSnp(this.dbsnp);
            }
            task.setProxies(this.proxies);
            task.setVcfFilename(vcf);
            task.setMinR2(this.minR2);
            task.setGenotypeFormat(this.genotypeFormat);
            if (this.outputVariantFilename != null) {
                task.setOutputVariantFilename(taskPrefix + ".variants.txt");
            }
            if (this.outputEffectsFilename != null) {
                task.setOutputEffectsFilename(taskPrefix + ".effects.txt");
            }
            task.setIncludeVariantFilename(this.includeVariantFilename);
            task.setIncludeSamplesFilename(this.includeSamplesFilename);
            task.setOutput(taskPrefix + ".scores.txt");
            task.setFixStrandFlips(this.fixStrandFlips);
            task.setRemoveAmbiguous(this.removeAmbiguous);
            task.setInverseDosage(this.inverseDosage);
            tasks.add(task);
        }
        TaskService.setThreads((int)this.threads);
        List results = TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_LONG_TASK}).run(tasks);
        if (this.isFailed(results)) {
            this.cleanUp();
            return 1;
        }
        System.out.println();
        MergeScoreTask mergeScore = new MergeScoreTask();
        mergeScore.setInputs(tasks);
        mergeScore.setOutput(this.out);
        if (this.isFailed(TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_SHORT_TASK}).run(new ITaskRunnable[]{mergeScore}))) {
            this.cleanUp();
            return 1;
        }
        if (this.outputEffectsFilename != null) {
            MergeEffectsTask mergeEffectsTask = new MergeEffectsTask();
            mergeEffectsTask.setInputs(tasks);
            mergeEffectsTask.setOutput(this.outputEffectsFilename);
            if (this.isFailed(TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_SHORT_TASK}).run(new ITaskRunnable[]{mergeEffectsTask}))) {
                this.cleanUp();
                return 1;
            }
        }
        if (this.outputVariantFilename != null) {
            MergeVariantsTask mergeVariantsTask = new MergeVariantsTask();
            mergeVariantsTask.setInputs(tasks);
            mergeVariantsTask.setOutput(this.outputVariantFilename);
            if (this.isFailed(TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_SHORT_TASK}).run(new ITaskRunnable[]{mergeVariantsTask}))) {
                this.cleanUp();
                return 1;
            }
        }
        MergeReportTask mergeReport = new MergeReportTask();
        mergeReport.setInputs(tasks);
        mergeReport.setOutput(this.reportJson);
        if (this.isFailed(TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_SHORT_TASK}).run(new ITaskRunnable[]{mergeReport}))) {
            this.cleanUp();
            return 1;
        }
        ReportFile report = mergeReport.getResult();
        if (this.reportHtml != null) {
            if (this.meta != null) {
                metaFile = MetaFile.load(this.meta);
                report.mergeWithMeta(metaFile);
            }
            data = new OutputFile(this.out);
            CreateHtmlReportTask htmlReportTask = new CreateHtmlReportTask();
            htmlReportTask.setReport(report);
            htmlReportTask.setData(data);
            if (this.includeSamplesFilename != null) {
                SamplesFile samplesFile = new SamplesFile(this.includeSamplesFilename);
                samplesFile.buildIndex();
                htmlReportTask.setSamples(samplesFile);
            }
            htmlReportTask.setOutput(this.reportHtml);
            if (this.isFailed(TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_SHORT_TASK}).run(new ITaskRunnable[]{htmlReportTask}))) {
                this.cleanUp();
                return 1;
            }
        }
        if (this.reportCsv != null) {
            if (this.meta != null) {
                metaFile = MetaFile.load(this.meta);
                report.mergeWithMeta(metaFile);
            }
            data = new OutputFile(this.out);
            CreateHtmlReportTask htmlReportTask = new CreateHtmlReportTask();
            htmlReportTask.setReport(report);
            htmlReportTask.setData(data);
            if (this.includeSamplesFilename != null) {
                SamplesFile samplesFile = new SamplesFile(this.includeSamplesFilename);
                samplesFile.buildIndex();
                htmlReportTask.setSamples(samplesFile);
            }
            htmlReportTask.setTemplate("txt");
            htmlReportTask.setOutput(this.reportCsv);
            if (this.isFailed(TaskService.monitor((IProgressIndicator[])new IProgressIndicator[]{App.STYLE_SHORT_TASK}).run(new ITaskRunnable[]{htmlReportTask}))) {
                this.cleanUp();
                return 1;
            }
        }
        if (this.verbose) {
            for (RiskScoreSummary summary : report.getSummaries()) {
                System.out.println();
                System.out.println(summary);
                System.out.println("-------------------------");
                System.out.println();
            }
        }
        System.out.println();
        System.out.println("Execution Time: " + this.formatTime(watch.getElapsedTimeSecs()));
        System.out.println();
        watch.stop();
        this.cleanUp();
        return 0;
    }

    private String[] parseRef(String ref) {
        try {
            PGSCatalogIDFile file = new PGSCatalogIDFile(ref);
            return file.getIds();
        }
        catch (Exception e) {
            try {
                ScoresFile file = new ScoresFile(ref);
                return file.getFilenames();
            }
            catch (Exception e1) {
                String[] refs = ref.split(",");
                for (int i = 0; i < refs.length; ++i) {
                    refs[i] = refs[i].trim();
                }
                return refs;
            }
        }
    }

    public String formatTime(long timeInSeconds) {
        return String.format("%d min, %d sec", timeInSeconds / 60L, timeInSeconds % 60L);
    }

    private boolean isFailed(List<Task> tasks) {
        for (Task result : tasks) {
            if (result.getStatus().isSuccess()) continue;
            result.getStatus().getThrowable().printStackTrace();
            return true;
        }
        return false;
    }

    public void cleanUp() {
        String outParent = new File(this.out).getParent();
        String tempFolder = FileUtil.path((String[])new String[]{outParent, "temp"});
        File tempFolderFile = new File(tempFolder);
        if (tempFolderFile.exists()) {
            FileUtil.deleteDirectory((File)tempFolderFile);
        }
    }
}

